/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.operations.userdefined;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.LocalDate;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Statement;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.antlr.runtime.RecognitionException;
import org.apache.cassandra.cql3.CQLFragmentParser;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.CqlParser;
import org.apache.cassandra.cql3.conditions.ColumnCondition;
import org.apache.cassandra.cql3.statements.ModificationStatement;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.stress.generate.Distribution;
import org.apache.cassandra.stress.generate.DistributionFixed;
import org.apache.cassandra.stress.generate.PartitionGenerator;
import org.apache.cassandra.stress.generate.Row;
import org.apache.cassandra.stress.generate.SeedManager;
import org.apache.cassandra.stress.generate.values.Generator;
import org.apache.cassandra.stress.operations.PartitionOperation;
import org.apache.cassandra.stress.operations.userdefined.SchemaStatement;
import org.apache.cassandra.stress.report.Timer;
import org.apache.cassandra.stress.settings.StressSettings;
import org.apache.cassandra.stress.util.JavaDriverClient;
import org.apache.cassandra.utils.Pair;

public class CASQuery
extends SchemaStatement {
    private final ImmutableList<Integer> keysIndex;
    private final ImmutableMap<Integer, Integer> casConditionArgFreqMap;
    private final String readQuery;
    private PreparedStatement casReadConditionStatement;

    public CASQuery(Timer timer, StressSettings settings, PartitionGenerator generator, SeedManager seedManager, PreparedStatement statement, ConsistencyLevel cl, SchemaStatement.ArgSelect argSelect, String tableName) {
        super(timer, settings, new PartitionOperation.DataSpec(generator, seedManager, (Distribution)new DistributionFixed(1L), settings.insert.rowPopulationRatio.get(), argSelect == SchemaStatement.ArgSelect.MULTIROW ? statement.getVariables().size() : 1), statement, statement.getVariables().asList().stream().map(ColumnDefinitions.Definition::getName).collect(Collectors.toList()), cl);
        ModificationStatement.Parsed modificationStatement;
        if (argSelect != SchemaStatement.ArgSelect.SAMEROW) {
            throw new IllegalArgumentException("CAS is supported only for type 'samerow'");
        }
        try {
            modificationStatement = (ModificationStatement.Parsed)CQLFragmentParser.parseAnyUnhandled(CqlParser::updateStatement, (String)statement.getQueryString());
        }
        catch (RecognitionException e) {
            throw new IllegalArgumentException("could not parse update query:" + statement.getQueryString(), e);
        }
        List casConditionList = modificationStatement.getConditions();
        ArrayList<Integer> casConditionIndex = new ArrayList<Integer>();
        boolean first = true;
        StringBuilder casReadConditionQuery = new StringBuilder();
        casReadConditionQuery.append("SELECT ");
        for (Object condition : casConditionList) {
            if (!((ColumnCondition.Raw)((Pair)condition).right).getValue().getText().equals("?")) continue;
            if (!first) {
                casReadConditionQuery.append(", ");
            }
            casReadConditionQuery.append(((ColumnIdentifier)((Pair)condition).left).toString());
            casConditionIndex.add(this.getDataSpecification().partitionGenerator.indexOf(((ColumnIdentifier)((Pair)condition).left).toString()));
            first = false;
        }
        casReadConditionQuery.append(" FROM ").append(tableName).append(" WHERE ");
        first = true;
        ImmutableList.Builder keysBuilder = ImmutableList.builder();
        for (Generator key : this.getDataSpecification().partitionGenerator.getPartitionKey()) {
            if (!first) {
                casReadConditionQuery.append(" AND ");
            }
            casReadConditionQuery.append(key.name).append(" = ? ");
            keysBuilder.add((Object)this.getDataSpecification().partitionGenerator.indexOf(key.name));
            first = false;
        }
        for (Generator clusteringKey : this.getDataSpecification().partitionGenerator.getClusteringComponents()) {
            casReadConditionQuery.append(" AND ").append(clusteringKey.name).append(" = ? ");
            keysBuilder.add((Object)this.getDataSpecification().partitionGenerator.indexOf(clusteringKey.name));
        }
        this.keysIndex = keysBuilder.build();
        this.readQuery = casReadConditionQuery.toString();
        ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)casConditionIndex.size());
        for (Integer oneConditionIndex : casConditionIndex) {
            builder.put((Object)oneConditionIndex, (Object)Math.toIntExact(Arrays.stream(this.argumentIndex).filter(x -> x == oneConditionIndex).count()));
        }
        this.casConditionArgFreqMap = builder.build();
    }

    @Override
    public void run(JavaDriverClient client) throws IOException {
        this.timeWithRetry(new JavaDriverRun(client));
    }

    private BoundStatement bind(JavaDriverClient client) {
        Object[] keys = new Object[this.keysIndex.size()];
        Row row = (Row)this.getPartitions().get(0).next();
        for (int i = 0; i < this.keysIndex.size(); ++i) {
            keys[i] = row.get((Integer)this.keysIndex.get(i));
        }
        ResultSet rs = client.getSession().execute((Statement)this.casReadConditionStatement.bind(keys));
        Object[] casDbValues = new Object[this.casConditionArgFreqMap.size()];
        com.datastax.driver.core.Row casDbValue = rs.one();
        if (casDbValue != null) {
            for (int i = 0; i < this.casConditionArgFreqMap.size(); ++i) {
                casDbValues[i] = casDbValue.getObject(i);
            }
        }
        return this.prepare(row, casDbValues);
    }

    private BoundStatement prepare(Row row, Object[] casDbValues) {
        HashMap<Integer, Integer> localMapping = new HashMap<Integer, Integer>((Map<Integer, Integer>)this.casConditionArgFreqMap);
        int conditionIndexTracker = 0;
        for (int i = 0; i < this.argumentIndex.length; ++i) {
            boolean replace = false;
            Integer count = (Integer)localMapping.get(this.argumentIndex[i]);
            if (count != null) {
                Integer n = count;
                Integer n2 = count = Integer.valueOf(count - 1);
                localMapping.put(this.argumentIndex[i], count);
                if (count == 0) {
                    replace = true;
                }
            }
            if (replace) {
                this.bindBuffer[i] = casDbValues[conditionIndexTracker++];
            } else {
                Object value = row.get(this.argumentIndex[i]);
                if (this.definitions.getType(i).getName() == DataType.date().getName()) {
                    value = LocalDate.fromDaysSinceEpoch((int)((Integer)value));
                }
                this.bindBuffer[i] = value;
            }
            if (this.bindBuffer[i] != null || this.getDataSpecification().partitionGenerator.permitNulls(this.argumentIndex[i])) continue;
            throw new IllegalStateException();
        }
        return this.statement.bind(this.bindBuffer);
    }

    private class JavaDriverRun
    extends SchemaStatement.Runner {
        final JavaDriverClient client;

        private JavaDriverRun(JavaDriverClient client) {
            super(CASQuery.this);
            this.client = client;
            CASQuery.this.casReadConditionStatement = client.prepare(CASQuery.this.readQuery);
        }

        @Override
        public boolean run() {
            ResultSet rs = this.client.getSession().execute((Statement)CASQuery.this.bind(this.client));
            this.rowCount = rs.all().size();
            this.partitionCount = Math.min(1, this.rowCount);
            return true;
        }
    }
}

