/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool;

import com.beust.jcommander.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.gridkit.jvmtool.GlobHelper;
import org.gridkit.lab.jvm.attach.JavaProcessDetails;
import org.gridkit.lab.jvm.attach.JavaProcessMatcher;

public class JvmProcessFilter
implements JavaProcessMatcher {
    @Parameter(names={"-fd", "--filter-description"}, description="Wild card expression to match process description")
    private String descFilter;
    @Parameter(names={"-fp", "--filter-property"}, variableArity=true, description="Wild card expressions to match JVM system properties")
    private List<String> propFilters;
    private Pattern descPattern;
    private List<Pattern> propPatterns;

    public boolean isDefined() {
        return this.descFilter != null || this.propFilters != null;
    }

    public void prepare() {
        if (this.descFilter != null) {
            this.descPattern = GlobHelper.translate(this.descFilter, "\u0000");
        }
        if (this.propFilters != null) {
            this.propPatterns = new ArrayList<Pattern>();
            for (String pp : this.propFilters) {
                Pattern tp = GlobHelper.translate(pp, ".");
                this.propPatterns.add(tp);
            }
        }
    }

    public boolean evaluate(JavaProcessDetails proc) {
        if (this.descPattern != null && !this.descPattern.matcher(proc.getDescription()).matches()) {
            return false;
        }
        if (this.propPatterns != null) {
            ArrayList<String> props = new ArrayList<String>();
            for (Map.Entry<Object, Object> e : proc.getSystemProperties().entrySet()) {
                props.add(e.getKey() + "=" + e.getValue());
            }
            block1: for (Pattern pp : this.propPatterns) {
                for (String p : props) {
                    if (!pp.matcher(p).matches()) continue;
                    continue block1;
                }
                return false;
            }
        }
        return true;
    }
}

