/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import org.apache.commons.io.output.BrokenWriter;
import org.apache.commons.io.output.UncheckedFilterWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

class UncheckedFilterWriterTest {
    private IOException exception;
    private UncheckedFilterWriter brokenWriter;
    private UncheckedFilterWriter stringWriter;

    UncheckedFilterWriterTest() {
    }

    @BeforeEach
    public void setUp() throws IOException {
        this.exception = new IOException("test exception");
        this.brokenWriter = ((UncheckedFilterWriter.Builder)UncheckedFilterWriter.builder().setWriter((Writer)new BrokenWriter(this.exception))).get();
        this.stringWriter = ((UncheckedFilterWriter.Builder)UncheckedFilterWriter.builder().setWriter((Writer)new StringWriter())).get();
    }

    @Test
    void testAppendChar() {
        this.stringWriter.append('1');
    }

    @Test
    void testAppendCharSequence() {
        this.stringWriter.append((CharSequence)"01");
    }

    @Test
    void testAppendCharSequenceIndexed() {
        this.stringWriter.append((CharSequence)"01", 0, 1);
    }

    @Test
    void testAppendCharSequenceIndexedThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.brokenWriter.append((CharSequence)"01", 0, 1))).getCause());
    }

    @Test
    void testAppendCharSequenceThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.brokenWriter.append((CharSequence)"01"))).getCause());
    }

    @Test
    void testAppendCharThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.brokenWriter.append('1'))).getCause());
    }

    @Test
    void testClose() {
        this.stringWriter.close();
    }

    @Test
    void testCloseThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.brokenWriter.close())).getCause());
    }

    @Test
    void testEquals() {
        this.stringWriter.equals(null);
    }

    @Test
    @Disabled(value="What should happen here?")
    void testEqualsThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.brokenWriter.equals(null))).getCause());
    }

    @Test
    void testFlush() {
        this.stringWriter.flush();
    }

    @Test
    void testFlushThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.brokenWriter.flush())).getCause());
    }

    @Test
    void testHashCode() {
        this.stringWriter.hashCode();
    }

    @Test
    @Disabled(value="What should happen here?")
    void testHashCodeThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.brokenWriter.hashCode())).getCause());
    }

    @Test
    void testToString() {
        this.stringWriter.toString();
    }

    @Test
    @Disabled(value="What should happen here?")
    void testToStringThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.brokenWriter.toString())).getCause());
    }

    @Test
    void testWriteCharArray() {
        this.stringWriter.write(new char[1]);
    }

    @Test
    void testWriteCharArrayIndexed() {
        this.stringWriter.write(new char[1], 0, 1);
    }

    @Test
    void testWriteCharArrayIndexedThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.brokenWriter.write(new char[1], 0, 1))).getCause());
    }

    @Test
    void testWriteCharArrayThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.brokenWriter.write(new char[1]))).getCause());
    }

    @Test
    void testWriteInt() {
        this.stringWriter.write(1);
    }

    @Test
    void testWriteIntThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.brokenWriter.write(1))).getCause());
    }

    @Test
    void testWriteString() {
        this.stringWriter.write("01");
    }

    @Test
    void testWriteStringIndexed() {
        this.stringWriter.write("01", 0, 1);
    }

    @Test
    void testWriteStringIndexedThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.brokenWriter.write("01", 0, 1))).getCause());
    }

    @Test
    void testWriteStringThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.brokenWriter.write("01"))).getCause());
    }
}

