/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import org.apache.commons.jxpath.AbstractFactory;
import org.apache.commons.jxpath.AbstractJXPathTest;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.TestBean;
import org.apache.commons.jxpath.TestMixedModelBean;
import org.apache.commons.jxpath.TestNull;
import org.apache.commons.jxpath.Variables;
import org.apache.commons.jxpath.ri.model.ExceptionPropertyTestBean;
import org.apache.commons.jxpath.ri.model.TestMixedModelFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MixedModelTest
extends AbstractJXPathTest {
    private JXPathContext context;

    @Override
    @BeforeEach
    public void setUp() {
        TestMixedModelBean bean = new TestMixedModelBean();
        this.context = JXPathContext.newContext((Object)bean);
        this.context.setFactory((AbstractFactory)new TestMixedModelFactory());
        this.context.setLocale(Locale.US);
        Variables vars = this.context.getVariables();
        vars.declareVariable("string", (Object)bean.getString());
        vars.declareVariable("bean", (Object)bean.getBean());
        vars.declareVariable("map", (Object)bean.getMap());
        vars.declareVariable("list", (Object)bean.getList());
        vars.declareVariable("document", (Object)bean.getDocument());
        vars.declareVariable("element", (Object)bean.getElement());
        vars.declareVariable("container", (Object)bean.getContainer());
        vars.declareVariable("testnull", (Object)new TestNull());
        int[][] matrix = new int[][]{new int[1]};
        matrix[0][0] = 3;
        vars.declareVariable("matrix", (Object)matrix);
    }

    @Test
    public void testBeanBean() {
        this.assertXPathValueAndPointer(this.context, "bean/int", 1, "/bean/int");
    }

    @Test
    public void testBeanContainer() {
        this.assertXPathValueAndPointer(this.context, "container/vendor/location/address/city", "Fruit Market", "/container/vendor[1]/location[2]/address[1]/city[1]");
    }

    @Test
    public void testBeanDocument() {
        this.assertXPathValueAndPointer(this.context, "document/vendor/location/address/city", "Fruit Market", "/document/vendor[1]/location[2]/address[1]/city[1]");
    }

    @Test
    public void testBeanElement() {
        this.assertXPathValueAndPointer(this.context, "element/location/address/city", "Fruit Market", "/element/location[2]/address[1]/city[1]");
    }

    @Test
    public void testBeanList() {
        this.assertXPathValueAndPointer(this.context, "list[1]", "string", "/list[1]");
    }

    @Test
    public void testBeanMap() {
        this.assertXPathValueAndPointer(this.context, "map/string", "string", "/map[@name='string']");
    }

    @Test
    public void testBeanPrimitive() {
        this.assertXPathValueAndPointer(this.context, "string", "string", "/string");
    }

    @Test
    public void testCollectionPointer() {
        ArrayList<Cloneable> list = new ArrayList<Cloneable>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("KeyOne", "SomeStringOne");
        map.put("KeyTwo", "SomeStringTwo");
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.put("KeyA", "StringA");
        map2.put("KeyB", "StringB");
        map.put("KeyThree", map2);
        list.add(map);
        ArrayList<Object> list2 = new ArrayList<Object>();
        list2.add("foo");
        list2.add(map);
        list2.add(map);
        list.add(list2);
        this.context = JXPathContext.newContext(list);
        Assertions.assertEquals((Object)"SomeStringOne", (Object)this.context.getValue(".[1]/KeyOne"));
        Assertions.assertEquals((Object)"StringA", (Object)this.context.getValue(".[1]/KeyThree/KeyA"));
        Assertions.assertEquals((Object)3, (Object)this.context.getValue("size(.[1]/KeyThree)"));
        Assertions.assertEquals((Object)6.0, (Object)this.context.getValue("count(.[1]/KeyThree/*)"));
        Assertions.assertEquals((Object)3.0, (Object)this.context.getValue("count(.[1]/KeyThree/KeyA)"));
    }

    @Test
    public void testCreatePath() {
        this.context = JXPathContext.newContext((Object)new TestBean());
        this.context.setFactory((AbstractFactory)new TestMixedModelFactory());
        TestBean bean = (TestBean)this.context.getContextBean();
        bean.setMap(null);
        this.assertXPathCreatePath(this.context, "/map[@name='TestKey5']/nestedBean/int", 1, "/map[@name='TestKey5']/nestedBean/int");
        bean.setMap(null);
        this.assertXPathCreatePath(this.context, "/map[@name='TestKey5']/beans[2]/int", 1, "/map[@name='TestKey5']/beans[2]/int");
    }

    @Test
    public void testCreatePathAndSetValueWithMatrix() {
        this.context.setValue("matrix", null);
        this.assertXPathCreatePathAndSetValue(this.context, "/matrix[1]/.[1]", 4, "/matrix[1]/.[1]");
    }

    @Test
    public void testErrorProperty() {
        this.context.getVariables().declareVariable("e", (Object)new ExceptionPropertyTestBean());
        Assertions.assertThrows(Throwable.class, () -> this.assertXPathValue(this.context, "$e/errorString", null), (String)"Legitimate exception accessing property");
        this.assertXPathPointer(this.context, "$e/errorString", "$e/errorString");
        this.assertXPathPointerLenient(this.context, "$e/errorStringArray[1]", "$e/errorStringArray[1]");
        this.assertXPathPointerIterator(this.context, "$e/errorString", MixedModelTest.list("$e/errorString"));
        this.assertXPathPointerIterator(this.context, "$e//error", Collections.EMPTY_LIST);
    }

    @Test
    public void testIterateArray() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        map.put("foo", new String[]{"a", "b", "c"});
        JXPathContext context = JXPathContext.newContext(map);
        this.assertXPathValueIterator(context, "foo", MixedModelTest.list("a", "b", "c"));
    }

    @Test
    public void testIteratePointersArray() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        map.put("foo", new String[]{"a", "b", "c"});
        JXPathContext context = JXPathContext.newContext(map);
        Iterator it = context.iteratePointers("foo");
        ArrayList<Object> actual = new ArrayList<Object>();
        while (it.hasNext()) {
            Pointer ptr = (Pointer)it.next();
            actual.add(context.getValue(ptr.asPath()));
        }
        Assertions.assertEquals((Object)MixedModelTest.list("a", "b", "c"), actual, (String)"Iterating pointers <foo>");
    }

    @Test
    public void testIteratePointersArrayElementWithVariable() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        map.put("foo", new String[]{"a", "b", "c"});
        JXPathContext context = JXPathContext.newContext(map);
        context.getVariables().declareVariable("x", (Object)2);
        Iterator it = context.iteratePointers("foo[$x]");
        ArrayList<Object> actual = new ArrayList<Object>();
        while (it.hasNext()) {
            Pointer ptr = (Pointer)it.next();
            actual.add(context.getValue(ptr.asPath()));
        }
        Assertions.assertEquals((Object)MixedModelTest.list("b"), actual, (String)"Iterating pointers <foo>");
    }

    @Test
    public void testIterateVector() {
        HashMap map = new HashMap();
        Vector vec = new Vector();
        vec.add(new HashMap());
        vec.add(new HashMap());
        map.put("vec", vec);
        JXPathContext context = JXPathContext.newContext(map);
        this.assertXPathPointerIterator(context, "/vec", MixedModelTest.list("/.[@name='vec'][1]", "/.[@name='vec'][2]"));
    }

    @Test
    public void testListBean() {
        this.assertXPathValueAndPointer(this.context, "list[2]/int", 1, "/list[2]/int");
    }

    @Test
    public void testListContainer() {
        this.assertXPathValueAndPointer(this.context, "list[7]/vendor/location/address/city", "Fruit Market", "/list[7]/vendor[1]/location[2]/address[1]/city[1]");
    }

    @Test
    public void testListDocument() {
        this.assertXPathValueAndPointer(this.context, "list[5]/vendor/location/address/city", "Fruit Market", "/list[5]/vendor[1]/location[2]/address[1]/city[1]");
    }

    @Test
    public void testListElement() {
        this.assertXPathValueAndPointer(this.context, "list[6]/location/address/city", "Fruit Market", "/list[6]/location[2]/address[1]/city[1]");
    }

    @Test
    public void testListList() {
        this.assertXPathValueAndPointer(this.context, "list[4]/.[1]", "string2", "/list[4]/.[1]");
    }

    @Test
    public void testListMap() {
        this.assertXPathValueAndPointer(this.context, "list[3]/string", "string", "/list[3][@name='string']");
    }

    @Test
    public void testListPrimitive() {
        this.assertXPathValueAndPointer(this.context, "list[1]", "string", "/list[1]");
    }

    @Test
    public void testMapBean() {
        this.assertXPathValueAndPointer(this.context, "map/bean/int", 1, "/map[@name='bean']/int");
    }

    @Test
    public void testMapContainer() {
        this.assertXPathValueAndPointer(this.context, "map/container/vendor/location/address/city", "Fruit Market", "/map[@name='container']/vendor[1]/location[2]/address[1]/city[1]");
    }

    @Test
    public void testMapDocument() {
        this.assertXPathValueAndPointer(this.context, "map/document/vendor/location/address/city", "Fruit Market", "/map[@name='document']/vendor[1]/location[2]/address[1]/city[1]");
    }

    @Test
    public void testMapElement() {
        this.assertXPathValueAndPointer(this.context, "map/element/location/address/city", "Fruit Market", "/map[@name='element']/location[2]/address[1]/city[1]");
    }

    @Test
    public void testMapList() {
        this.assertXPathValueAndPointer(this.context, "map/list[1]", "string", "/map[@name='list'][1]");
    }

    @Test
    public void testMapMap() {
        this.assertXPathValueAndPointer(this.context, "map/map/string", "string", "/map[@name='map'][@name='string']");
    }

    @Test
    public void testMapPrimitive() {
        this.assertXPathValueAndPointer(this.context, "map/string", "string", "/map[@name='string']");
    }

    @Test
    public void testMatrix() {
        this.assertXPathValueAndPointer(this.context, "$matrix[1]/.[1]", 3, "$matrix[1]/.[1]");
        this.context.setValue("$matrix[1]/.[1]", (Object)2);
        this.assertXPathValueAndPointer(this.context, "matrix[1]/.[1]", 3, "/matrix[1]/.[1]");
        this.context.setValue("matrix[1]/.[1]", (Object)"2");
        this.assertXPathValue(this.context, "matrix[1]/.[1]", 2);
        this.context.getVariables().declareVariable("wholebean", this.context.getContextBean());
        this.assertXPathValueAndPointer(this.context, "$wholebean/matrix[1]/.[1]", 2, "$wholebean/matrix[1]/.[1]");
        Assertions.assertThrows(Exception.class, () -> this.context.setValue("$wholebean/matrix[1]/.[2]", (Object)"4"), (String)"Exception setting value of non-existent element");
        Assertions.assertThrows(Exception.class, () -> this.context.setValue("$wholebean/matrix[2]/.[1]", (Object)"4"), (String)"Exception setting value of non-existent element");
    }

    @Test
    public void testNull() {
        this.assertXPathPointerLenient(this.context, "$null", "$null");
        this.assertXPathPointerLenient(this.context, "$null[3]", "$null[3]");
        this.assertXPathPointerLenient(this.context, "$testnull/nothing", "$testnull/nothing");
        this.assertXPathPointerLenient(this.context, "$testnull/nothing[2]", "$testnull/nothing[2]");
        this.assertXPathPointerLenient(this.context, "beans[8]/int", "/beans[8]/int");
        this.assertXPathValueIterator(this.context, "$testnull/nothing[1]", MixedModelTest.list(null));
        JXPathContext ctx = JXPathContext.newContext((Object)new TestNull());
        this.assertXPathValue(ctx, "nothing", null);
        this.assertXPathValue(ctx, "child/nothing", null);
        this.assertXPathValue(ctx, "array[2]", null);
        this.assertXPathValueLenient(ctx, "nothing/something", null);
        this.assertXPathValueLenient(ctx, "array[2]/something", null);
    }

    @Test
    public void testRootAsCollection() {
        this.assertXPathValue(this.context, ".[1]/string", "string");
    }

    @Test
    public void testVar() {
        this.context.getVariables().declareVariable("foo:bar", (Object)"baz");
        this.assertXPathValueAndPointer(this.context, "$foo:bar", "baz", "$foo:bar");
    }

    @Test
    public void testVarBean() {
        this.assertXPathValueAndPointer(this.context, "$bean/int", 1, "$bean/int");
    }

    @Test
    public void testVarContainer() {
        this.assertXPathValueAndPointer(this.context, "$container/vendor/location/address/city", "Fruit Market", "$container/vendor[1]/location[2]/address[1]/city[1]");
    }

    @Test
    public void testVarDocument() {
        this.assertXPathValueAndPointer(this.context, "$document/vendor/location/address/city", "Fruit Market", "$document/vendor[1]/location[2]/address[1]/city[1]");
    }

    @Test
    public void testVarElement() {
        this.assertXPathValueAndPointer(this.context, "$element/location/address/city", "Fruit Market", "$element/location[2]/address[1]/city[1]");
    }

    @Test
    public void testVarList() {
        this.assertXPathValueAndPointer(this.context, "$list[1]", "string", "$list[1]");
    }

    @Test
    public void testVarMap() {
        this.assertXPathValueAndPointer(this.context, "$map/string", "string", "$map[@name='string']");
    }

    @Test
    public void testVarPrimitive() {
        this.assertXPathValueAndPointer(this.context, "$string", "string", "$string");
    }
}

