/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.stream;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.LangAssertions;
import org.apache.commons.lang3.function.Failable;
import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.commons.lang3.function.FailablePredicate;
import org.apache.commons.lang3.stream.Streams;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestFactory;
import org.junit.jupiter.api.function.Executable;
import org.xml.sax.SAXException;

class StreamsTest
extends AbstractLangTest {
    StreamsTest() {
    }

    protected <T extends Throwable> FailableConsumer<String, T> asIntConsumer(T throwable) {
        return s -> {
            int i = Integer.parseInt(s);
            if (i == 4) {
                throw throwable;
            }
        };
    }

    protected <T extends Throwable> FailablePredicate<Integer, T> asIntPredicate(T throwable) {
        return i -> {
            if (i == 5 && throwable != null) {
                throw throwable;
            }
            return i % 2 == 0;
        };
    }

    private void assertEvenNumbers(List<Integer> output) {
        Assertions.assertEquals((int)3, (int)output.size());
        for (int i = 0; i < 3; ++i) {
            Assertions.assertEquals((int)((i + 1) * 2), (int)output.get(i));
        }
    }

    @TestFactory
    public Stream<DynamicTest> simpleStreamFilterFailing() {
        List<String> input = Arrays.asList("1", "2", "3", "4", "5", "6");
        List output = (List)Failable.stream(input).map(Integer::valueOf).filter(this.asIntPredicate(null)).collect(Collectors.toList());
        this.assertEvenNumbers(output);
        return Stream.of(DynamicTest.dynamicTest((String)"IllegalArgumentException", () -> {
            IllegalArgumentException iae = new IllegalArgumentException("Invalid argument: 5");
            Executable testMethod = () -> Failable.stream((Collection)input).map(Integer::valueOf).filter(this.asIntPredicate(iae)).collect(Collectors.toList());
            IllegalArgumentException thrown = LangAssertions.assertIllegalArgumentException(testMethod);
            Assertions.assertEquals((Object)"Invalid argument: 5", (Object)thrown.getMessage());
        }), DynamicTest.dynamicTest((String)"OutOfMemoryError", () -> {
            OutOfMemoryError oome = new OutOfMemoryError();
            Executable testMethod = () -> Failable.stream((Collection)input).map(Integer::valueOf).filter(this.asIntPredicate(oome)).collect(Collectors.toList());
            OutOfMemoryError thrown = (OutOfMemoryError)Assertions.assertThrows(OutOfMemoryError.class, (Executable)testMethod);
            Assertions.assertNull((Object)thrown.getMessage());
        }), DynamicTest.dynamicTest((String)"SAXException", () -> {
            SAXException se = new SAXException();
            Executable testMethod = () -> Failable.stream((Collection)input).map(Integer::valueOf).filter(this.asIntPredicate(se)).collect(Collectors.toList());
            UndeclaredThrowableException thrown = (UndeclaredThrowableException)Assertions.assertThrows(UndeclaredThrowableException.class, (Executable)testMethod);
            Assertions.assertNull((Object)thrown.getMessage());
            Assertions.assertEquals((Object)se, (Object)thrown.getCause());
        }));
    }

    @TestFactory
    public Stream<DynamicTest> simpleStreamForEachFailing() {
        List<String> input = Arrays.asList("1", "2", "3", "4", "5", "6");
        return Stream.of(DynamicTest.dynamicTest((String)"IllegalArgumentException", () -> {
            IllegalArgumentException ise = new IllegalArgumentException();
            Executable testMethod = () -> Failable.stream((Collection)input).forEach(this.asIntConsumer(ise));
            IllegalArgumentException thrown = LangAssertions.assertIllegalArgumentException(testMethod);
            Assertions.assertNull((Object)thrown.getMessage());
        }), DynamicTest.dynamicTest((String)"OutOfMemoryError", () -> {
            OutOfMemoryError oome = new OutOfMemoryError();
            Executable oomeTestMethod = () -> Failable.stream((Collection)input).forEach(this.asIntConsumer(oome));
            OutOfMemoryError oomeThrown = (OutOfMemoryError)Assertions.assertThrows(OutOfMemoryError.class, (Executable)oomeTestMethod);
            Assertions.assertNull((Object)oomeThrown.getMessage());
        }), DynamicTest.dynamicTest((String)"SAXException", () -> {
            SAXException se = new SAXException();
            Executable seTestMethod = () -> Failable.stream((Collection)input).forEach(this.asIntConsumer(se));
            UndeclaredThrowableException seThrown = (UndeclaredThrowableException)Assertions.assertThrows(UndeclaredThrowableException.class, (Executable)seTestMethod);
            Assertions.assertNull((Object)seThrown.getMessage());
            Assertions.assertEquals((Object)se, (Object)seThrown.getCause());
        }));
    }

    @Test
    void testArrayCollectorCombiner() {
        Object[] expected = new String[]{"A1", "B1"};
        Assertions.assertArrayEquals((Object[])expected, (Object[])((Object[])Stream.of("A", "B").collect(Collectors.mapping(s -> s + "1", Streams.toArray(String.class)))));
        Assertions.assertArrayEquals((Object[])expected, (Object[])((Object[])Streams.failableStream((Object[])new String[]{"A", "B"}).collect(Collectors.mapping(s -> s + "1", Streams.toArray(String.class)))));
        ArrayList<String> left = new ArrayList<String>();
        left.add("a");
        Assertions.assertEquals(Arrays.asList("a", "b", "c"), Streams.toArray(String.class).combiner().apply(left, Arrays.asList("b", "c")));
    }

    @Test
    void testAssertNotTerminated() {
        Streams.FailableStream stream = Streams.failableStream((Object[])new String[]{"A", "B"});
        Assertions.assertTrue((boolean)stream.allMatch(s -> s.length() == 1));
        Assertions.assertThrows(IllegalStateException.class, () -> stream.allMatch(null));
    }

    @Test
    void testDeprefcatedCopnstructor() {
        Assertions.assertNotNull((Object)new Streams().toString());
    }

    @Test
    void testFailableAllMatch() {
        Assertions.assertTrue((boolean)Streams.failableStream((Object[])new String[]{"A", "B"}).allMatch(s -> s.length() == 1));
        Assertions.assertFalse((boolean)Streams.failableStream((Object[])new String[]{"A", "B"}).allMatch(s -> s.length() == 2));
    }

    @Test
    void testFailableAnyMatch() {
        Assertions.assertTrue((boolean)Streams.failableStream((Object[])new String[]{"A", "B"}).anyMatch(s -> s.length() == 1));
        Assertions.assertTrue((boolean)Streams.failableStream((Object[])new String[]{"A", "BC"}).anyMatch(s -> s.length() == 1));
        Assertions.assertFalse((boolean)Streams.failableStream((Object[])new String[]{"A", "B"}).anyMatch(s -> s.length() == 2));
    }

    @Test
    void testFailableCollect() {
        Assertions.assertEquals(Arrays.asList("A", "B"), (Object)Streams.failableStream((Object[])new String[]{"A", "B"}).collect(ArrayList::new, ArrayList::add, ArrayList::addAll));
    }

    @Test
    void testFailableReduce() {
        Assertions.assertEquals((int)3, (Integer)((Integer)Streams.failableStream((Object[])new Integer[]{1, 2}).reduce((Object)0, (a, b) -> a + b)));
    }

    @Test
    void testFailableStream() {
        Assertions.assertEquals((int)1, (int)((List)Streams.failableStream((Object)1).collect(Collectors.toList())).size());
        Assertions.assertEquals((int)0, (int)((List)Streams.failableStream(Stream.empty()).collect(Collectors.toList())).size());
    }

    @Test
    void testInstanceOfStream() {
        Assertions.assertEquals((int)2, (int)Streams.instancesOf(String.class, Arrays.asList("A", "B")).collect(Collectors.toList()).size());
        Assertions.assertEquals((int)2, (int)Streams.instancesOf(String.class, Arrays.asList(null, "A", null, "B", null)).collect(Collectors.toList()).size());
        Assertions.assertEquals((int)0, (int)Streams.instancesOf(String.class, Arrays.asList(null, null)).collect(Collectors.toList()).size());
        List<Object> objects = Arrays.asList("A", "B");
        Assertions.assertEquals((int)2, (int)Streams.instancesOf(String.class, objects).collect(Collectors.toList()).size());
    }

    @Test
    void testNonNull() {
        Assertions.assertEquals((int)0, (int)Streams.nonNull((Object[])new Object[0]).collect(Collectors.toList()).size());
        Assertions.assertEquals((int)0, (int)Streams.nonNull((Stream)null).collect(Collectors.toList()).size());
        Assertions.assertEquals((int)1, (int)Streams.nonNull((Object)"A").collect(Collectors.toList()).size());
        Assertions.assertEquals((int)1, (int)Streams.nonNull((Object[])new String[]{"A", null}).collect(Collectors.toList()).size());
        Assertions.assertEquals((int)1, (int)Streams.nonNull((Object[])new String[]{null, "A"}).collect(Collectors.toList()).size());
    }

    @Test
    void testNullSafeStreamNotNull() {
        Assertions.assertEquals((int)2, (int)Streams.nonNull(Arrays.asList("A", "B")).collect(Collectors.toList()).size());
        Assertions.assertEquals((int)2, (int)Streams.nonNull(Arrays.asList(null, "A", null, "B", null)).collect(Collectors.toList()).size());
        Assertions.assertEquals((int)0, (int)Streams.nonNull(Arrays.asList(null, null)).collect(Collectors.toList()).size());
    }

    @Test
    void testNullSafeStreamNull() {
        Collection input = null;
        Assertions.assertEquals((int)0, (int)Streams.nonNull(input).collect(Collectors.toList()).size());
    }

    @Test
    void testOfArray() {
        Assertions.assertEquals((long)0L, (long)Streams.of((Object[])null).count());
        Assertions.assertEquals((long)1L, (long)Streams.of((Object[])new String[]{"foo"}).count());
        Assertions.assertEquals((long)2L, (long)Streams.of((Object[])new String[]{"foo", "bar"}).count());
    }

    @Test
    void testOfCollectionNotNull() {
        Assertions.assertEquals((int)2, (int)Streams.of(Arrays.asList("A", "B")).collect(Collectors.toList()).size());
    }

    @Test
    void testOfCollectionNull() {
        Collection input = null;
        Assertions.assertEquals((int)0, (int)Streams.of(input).collect(Collectors.toList()).size());
    }

    @Test
    void testOfEnumeration() {
        Hashtable<String, Integer> table = new Hashtable<String, Integer>();
        Assertions.assertEquals((long)0L, (long)Streams.of(table.elements()).count());
        table.put("One", 1);
        Assertions.assertEquals((long)1L, (long)Streams.of(table.elements()).count());
        table.put("Two", 2);
        Assertions.assertEquals((long)2L, (long)Streams.of(table.elements()).count());
        List collect = Streams.of(table.keys()).collect(Collectors.toList());
        Assertions.assertTrue((boolean)collect.contains("One"));
        Assertions.assertTrue((boolean)collect.contains("Two"));
        Assertions.assertEquals((int)2, (int)collect.size());
        Assertions.assertFalse((boolean)Streams.of(table.keys()).filter(String::isEmpty).findFirst().isPresent());
        Assertions.assertEquals(Arrays.asList("OneOne", "TwoTwo"), Streams.of(table.keys()).map(s -> s + s).collect(Collectors.toList()));
        Assertions.assertFalse((boolean)Streams.of(new Hashtable().keys()).filter(String::isEmpty).findFirst().isPresent());
    }

    @Test
    void testOfIterableNotNull() {
        Assertions.assertEquals((int)2, (int)Streams.of(Arrays.asList("A", "B")).collect(Collectors.toList()).size());
    }

    @Test
    void testOfIterableNull() {
        Iterable input = null;
        Assertions.assertEquals((int)0, (int)Streams.of(input).collect(Collectors.toList()).size());
    }

    @Test
    void testOfIteratorNotNull() {
        Assertions.assertEquals((int)2, (int)Streams.of(Arrays.asList("A", "B").iterator()).collect(Collectors.toList()).size());
    }

    @Test
    void testOfIteratorNull() {
        Iterator input = null;
        Assertions.assertEquals((int)0, (int)Streams.of(input).collect(Collectors.toList()).size());
    }

    @Test
    void testOfVarArg() {
        Assertions.assertEquals((int)1, (int)Streams.of((Object[])new Integer[]{1}).collect(Collectors.toList()).size());
        Assertions.assertEquals((int)2, (int)Streams.of((Object[])new Integer[]{1, 2}).collect(Collectors.toList()).size());
    }

    @Test
    void testSimpleStreamFilter() {
        List<String> input = Arrays.asList("1", "2", "3", "4", "5", "6");
        List output = (List)Failable.stream(input).map(Integer::valueOf).filter(i -> i % 2 == 0).collect(Collectors.toList());
        this.assertEvenNumbers(output);
    }

    @Test
    void testSimpleStreamForEach() {
        List<String> input = Arrays.asList("1", "2", "3", "4", "5", "6");
        ArrayList output = new ArrayList();
        Failable.stream(input).forEach(s -> output.add(Integer.valueOf(s)));
        Assertions.assertEquals((int)6, (int)output.size());
        for (int i = 0; i < 6; ++i) {
            Assertions.assertEquals((int)(i + 1), (int)((Integer)output.get(i)));
        }
    }

    @Test
    void testSimpleStreamMap() {
        List<String> input = Arrays.asList("1", "2", "3", "4", "5", "6");
        List output = (List)Failable.stream(input).map(Integer::valueOf).collect(Collectors.toList());
        Assertions.assertEquals((int)6, (int)output.size());
        for (int i = 0; i < 6; ++i) {
            Assertions.assertEquals((int)(i + 1), (int)((Integer)output.get(i)));
        }
    }

    @Test
    void testSimpleStreamMapFailing() {
        List<String> input = Arrays.asList("1", "2", "3", "4 ", "5", "6");
        Executable testMethod = () -> Failable.stream((Collection)input).map(Integer::valueOf).collect(Collectors.toList());
        NumberFormatException thrown = (NumberFormatException)Assertions.assertThrows(NumberFormatException.class, (Executable)testMethod);
        Assertions.assertEquals((Object)"For input string: \"4 \"", (Object)thrown.getMessage());
    }

    @Test
    void testStream() {
        Assertions.assertEquals((int)0, (int)((List)Streams.stream(Stream.empty()).collect(Collectors.toList())).size());
        Assertions.assertEquals((int)1, (int)((List)Streams.stream(Stream.of("")).collect(Collectors.toList())).size());
    }

    @Test
    void testStreamCollection() {
        List<String> input = Arrays.asList("1", "2", "3", "4", "5", "6");
        Assertions.assertEquals((int)6, (int)((List)Streams.stream(input).collect(Collectors.toList())).size());
    }

    @Test
    void testStreamCollectionNull() {
        Collection input = null;
        Assertions.assertEquals((int)0, (int)((List)Streams.stream(input).collect(Collectors.toList())).size());
    }

    @Test
    void testToArray() {
        String[] array = (String[])Arrays.asList("2", "3", "1").stream().collect(Streams.toArray(String.class));
        Assertions.assertNotNull((Object)array);
        Assertions.assertEquals((int)3, (int)array.length);
        Assertions.assertEquals((Object)"2", (Object)array[0]);
        Assertions.assertEquals((Object)"3", (Object)array[1]);
        Assertions.assertEquals((Object)"1", (Object)array[2]);
    }
}

