/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text;

import org.apache.commons.text.StrMatcher;
import org.apache.commons.text.StrSubstitutor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@Deprecated
class StrMatcherTest {
    private static final char[] BUFFER1 = "0,1\t2 3\n\r\f\u0000'\"".toCharArray();
    private static final char[] BUFFER2 = "abcdef".toCharArray();

    StrMatcherTest() {
    }

    static void assertStrMatcherImpl(String internalSimpleName, StrMatcher obj) {
        Assertions.assertEquals((Object)(StrMatcher.class.getName() + "$" + internalSimpleName), (Object)obj.getClass().getName());
    }

    static void assertStrMatcherPrefixImpl(String internalSimpleName, StrSubstitutor obj) {
        StrMatcherTest.assertStrMatcherImpl(internalSimpleName, obj.getVariablePrefixMatcher());
    }

    static void assertStrMatcherSuffixImpl(String internalSimpleName, StrSubstitutor obj) {
        StrMatcherTest.assertStrMatcherImpl(internalSimpleName, obj.getVariableSuffixMatcher());
    }

    @Test
    void testCharMatcher_char() {
        StrMatcher matcher = StrMatcher.charMatcher((char)'c');
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER2, 0));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER2, 1));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(BUFFER2, 2));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER2, 3));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER2, 4));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER2, 5));
    }

    @Test
    void testCharSetMatcher_charArray() {
        StrMatcher matcher = StrMatcher.charSetMatcher((char[])"ace".toCharArray());
        Assertions.assertEquals((int)1, (int)matcher.isMatch(BUFFER2, 0));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER2, 1));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(BUFFER2, 2));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER2, 3));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(BUFFER2, 4));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER2, 5));
        Assertions.assertSame((Object)StrMatcher.charSetMatcher((char[])new char[0]), (Object)StrMatcher.noneMatcher());
        Assertions.assertSame((Object)StrMatcher.charSetMatcher((char[])null), (Object)StrMatcher.noneMatcher());
        StrMatcherTest.assertStrMatcherImpl("CharMatcher", StrMatcher.charSetMatcher((char[])"a".toCharArray()));
    }

    @Test
    void testCharSetMatcher_String() {
        StrMatcher matcher = StrMatcher.charSetMatcher((String)"ace");
        Assertions.assertEquals((int)1, (int)matcher.isMatch(BUFFER2, 0));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER2, 1));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(BUFFER2, 2));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER2, 3));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(BUFFER2, 4));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER2, 5));
        Assertions.assertSame((Object)StrMatcher.charSetMatcher((String)""), (Object)StrMatcher.noneMatcher());
        Assertions.assertSame((Object)StrMatcher.charSetMatcher((String)null), (Object)StrMatcher.noneMatcher());
        StrMatcherTest.assertStrMatcherImpl("CharMatcher", StrMatcher.charSetMatcher((String)"a"));
    }

    @Test
    void testCommaMatcher() {
        StrMatcher matcher = StrMatcher.commaMatcher();
        Assertions.assertSame((Object)StrMatcher.commaMatcher(), (Object)matcher);
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 0));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(BUFFER1, 1));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 2));
    }

    @Test
    void testDoubleQuoteMatcher() {
        StrMatcher matcher = StrMatcher.doubleQuoteMatcher();
        Assertions.assertSame((Object)StrMatcher.doubleQuoteMatcher(), (Object)matcher);
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 11));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(BUFFER1, 12));
    }

    @Test
    void testMatcherIndices() {
        StrMatcher matcher = StrMatcher.stringMatcher((String)"bc");
        Assertions.assertEquals((int)2, (int)matcher.isMatch(BUFFER2, 1, 1, BUFFER2.length));
        Assertions.assertEquals((int)2, (int)matcher.isMatch(BUFFER2, 1, 0, 3));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER2, 1, 0, 2));
    }

    @Test
    void testNoneMatcher() {
        StrMatcher matcher = StrMatcher.noneMatcher();
        Assertions.assertSame((Object)StrMatcher.noneMatcher(), (Object)matcher);
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 0));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 1));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 2));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 3));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 4));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 5));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 6));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 7));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 8));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 9));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 10));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 11));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 12));
    }

    @Test
    void testQuoteMatcher() {
        StrMatcher matcher = StrMatcher.quoteMatcher();
        Assertions.assertSame((Object)StrMatcher.quoteMatcher(), (Object)matcher);
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 10));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(BUFFER1, 11));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(BUFFER1, 12));
    }

    @Test
    void testSingleQuoteMatcher() {
        StrMatcher matcher = StrMatcher.singleQuoteMatcher();
        Assertions.assertSame((Object)StrMatcher.singleQuoteMatcher(), (Object)matcher);
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 10));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(BUFFER1, 11));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 12));
    }

    @Test
    void testSpaceMatcher() {
        StrMatcher matcher = StrMatcher.spaceMatcher();
        Assertions.assertSame((Object)StrMatcher.spaceMatcher(), (Object)matcher);
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 4));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(BUFFER1, 5));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 6));
    }

    @Test
    void testSplitMatcher() {
        StrMatcher matcher = StrMatcher.splitMatcher();
        Assertions.assertSame((Object)StrMatcher.splitMatcher(), (Object)matcher);
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 2));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(BUFFER1, 3));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 4));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(BUFFER1, 5));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 6));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(BUFFER1, 7));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(BUFFER1, 8));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(BUFFER1, 9));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 10));
    }

    @Test
    void testStringMatcher_String() {
        StrMatcher matcher = StrMatcher.stringMatcher((String)"bc");
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER2, 0));
        Assertions.assertEquals((int)2, (int)matcher.isMatch(BUFFER2, 1));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER2, 2));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER2, 3));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER2, 4));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER2, 5));
        Assertions.assertSame((Object)StrMatcher.stringMatcher((String)""), (Object)StrMatcher.noneMatcher());
        Assertions.assertSame((Object)StrMatcher.stringMatcher((String)null), (Object)StrMatcher.noneMatcher());
    }

    @Test
    void testTabMatcher() {
        StrMatcher matcher = StrMatcher.tabMatcher();
        Assertions.assertSame((Object)StrMatcher.tabMatcher(), (Object)matcher);
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 2));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(BUFFER1, 3));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 4));
    }

    @Test
    void testTrimMatcher() {
        StrMatcher matcher = StrMatcher.trimMatcher();
        Assertions.assertSame((Object)StrMatcher.trimMatcher(), (Object)matcher);
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 2));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(BUFFER1, 3));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 4));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(BUFFER1, 5));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 6));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(BUFFER1, 7));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(BUFFER1, 8));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(BUFFER1, 9));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(BUFFER1, 10));
    }
}

