/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.configuration.builders;

import java.util.Map;
import org.apache.rat.ConfigurationException;
import org.apache.rat.analysis.IHeaderMatcher;
import org.apache.rat.analysis.IHeaders;
import org.apache.rat.config.parameters.ComponentType;
import org.apache.rat.config.parameters.ConfigComponent;
import org.apache.rat.config.parameters.MatcherBuilder;
import org.apache.rat.configuration.builders.AbstractBuilder;

@MatcherBuilder(value=IHeaderMatcherProxy.class)
public class MatcherRefBuilder
extends AbstractBuilder {
    private String referenceId;
    private Map<String, IHeaderMatcher> matchers;

    public MatcherRefBuilder setRefId(String refId) {
        this.referenceId = refId;
        return this;
    }

    public MatcherRefBuilder setMatcherMap(Map<String, IHeaderMatcher> matchers) {
        this.matchers = matchers;
        return this;
    }

    @Override
    public IHeaderMatcher build() {
        if (this.matchers == null) {
            throw new ConfigurationException("'matchers' not set");
        }
        IHeaderMatcher result = this.matchers.get(this.referenceId);
        return result != null ? result : new IHeaderMatcherProxy(this.referenceId, this.matchers);
    }

    @Override
    public String toString() {
        return "MatcherRefBuilder: " + this.referenceId;
    }

    @ConfigComponent(type=ComponentType.MATCHER, name="matcherRef", desc="A pointer to another Matcher")
    public static class IHeaderMatcherProxy
    implements IHeaderMatcher {
        @ConfigComponent(type=ComponentType.PARAMETER, name="refId", desc="Reference to an existing matcher", required=true)
        private final String proxyId;
        private IHeaderMatcher wrapped;
        @ConfigComponent(type=ComponentType.BUILD_PARAMETER, name="matcherMap", desc="Map of matcher names to matcher instances")
        private Map<String, IHeaderMatcher> matchers;

        public IHeaderMatcherProxy(String proxyId, Map<String, IHeaderMatcher> matchers) {
            this.proxyId = proxyId;
            this.matchers = matchers;
        }

        private void checkProxy() {
            if (this.wrapped == null) {
                this.wrapped = this.matchers.get(this.proxyId);
                if (this.wrapped == null) {
                    throw new IllegalStateException(String.format("%s is not a valid matcher id", this.proxyId));
                }
                this.matchers = null;
            }
        }

        @Override
        public String getId() {
            this.checkProxy();
            return this.wrapped.getId();
        }

        @Override
        public void reset() {
            this.checkProxy();
            this.wrapped.reset();
        }

        @Override
        public boolean matches(IHeaders header) {
            this.checkProxy();
            return this.wrapped.matches(header);
        }

        public String getRefId() {
            return this.proxyId;
        }
    }
}

