/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.execution;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.junit.platform.commons.util.ReflectionUtils;

class ConstructorInvocation<T>
implements InvocationInterceptor.Invocation<T>,
ReflectiveInvocationContext<Constructor<T>> {
    private final Constructor<T> constructor;
    private final Object[] arguments;

    ConstructorInvocation(Constructor<T> constructor, Object[] arguments) {
        this.constructor = constructor;
        this.arguments = arguments;
    }

    @Override
    public Class<?> getTargetClass() {
        return this.constructor.getDeclaringClass();
    }

    @Override
    public Constructor<T> getExecutable() {
        return this.constructor;
    }

    @Override
    public List<Object> getArguments() {
        return Collections.unmodifiableList(Arrays.asList(this.arguments));
    }

    @Override
    public Optional<Object> getTarget() {
        return Optional.empty();
    }

    @Override
    public T proceed() {
        return ReflectionUtils.newInstance(this.constructor, this.arguments);
    }
}

