/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jgroups.util.Bits;
import org.jgroups.util.SizeStreamable;

public class ByteArray
implements SizeStreamable {
    private byte[] array;
    private int offset;
    private int length;

    public ByteArray(byte[] array, int offset, int length) {
        this.array = array;
        this.offset = offset;
        this.length = length;
    }

    public ByteArray(byte[] array) {
        this(array, 0, array.length);
    }

    public byte[] getArray() {
        return this.array;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public ByteArray copy() {
        int new_length;
        byte[] new_buf = this.array != null ? new byte[this.length] : null;
        int n = new_length = new_buf != null ? new_buf.length : 0;
        if (new_buf != null) {
            System.arraycopy(this.array, this.offset, new_buf, 0, this.length);
        }
        return new ByteArray(new_buf, 0, new_length);
    }

    public byte[] getBytes() {
        if (this.array == null) {
            return null;
        }
        if (this.offset == 0 && this.length == this.array.length) {
            return this.array;
        }
        byte[] tmp = new byte[this.length];
        System.arraycopy(this.array, this.offset, tmp, 0, this.length);
        return tmp;
    }

    @Override
    public int serializedSize() {
        return Bits.size(this.length) + this.length;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        Bits.writeIntCompressed(this.length, out);
        if (this.length > 0) {
            out.write(this.array, this.offset, this.length);
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
        this.length = Bits.readIntCompressed(in);
        this.offset = 0;
        if (this.length > 0) {
            this.array = new byte[this.length];
            in.readFully(this.array);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.length).append(" bytes");
        if (this.offset > 0) {
            sb.append(" (offset=").append(this.offset).append(")");
        }
        return sb.toString();
    }
}

