/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.cxf.systest.factory_pattern;

import jakarta.annotation.Resource;
import jakarta.jws.WebService;
import jakarta.xml.ws.WebServiceContext;
import jakarta.xml.ws.handler.MessageContext;
import org.apache.cxf.ws.addressing.EndpointReferenceUtils;

@WebService(serviceName = "NumberService",
            endpointInterface = "org.apache.cxf.factory_pattern.Number",
            targetNamespace = "http://cxf.apache.org/factory_pattern")
public class HttpNumberImpl extends NumberImpl {
    @Resource
    protected WebServiceContext aContext;

    protected WebServiceContext getWebSercviceContext() {
        return aContext;
    }

    protected String idFromMessageContext(MessageContext mc) {
        return EndpointReferenceUtils.getEndpointReferenceId(mc);
    }
}
