/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.regexp;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UnicodeProperties {
    public static final byte ALPHABETIC = 1;
    public static final byte ASCII = 2;
    public static final byte CASE_IGNORABLE = 3;
    public static final byte ASCII_HEX_DIGIT = 4;
    public static final byte HEX_DIGIT = 5;
    public static final byte ID_CONTINUE = 6;
    public static final byte ID_START = 7;
    public static final byte LOWERCASE = 8;
    public static final byte UPPERCASE = 9;
    public static final byte WHITE_SPACE = 10;
    public static final byte GENERAL_CATEGORY = 11;
    public static final byte SCRIPT = 12;
    public static final byte OTHER = 1;
    public static final byte CONTROL = 2;
    public static final byte FORMAT = 3;
    public static final byte UNASSIGNED = 4;
    public static final byte PRIVATE_USE = 5;
    public static final byte SURROGATE = 6;
    public static final byte LETTER = 7;
    public static final byte LOWERCASE_LETTER = 8;
    public static final byte MODIFIER_LETTER = 9;
    public static final byte OTHER_LETTER = 10;
    public static final byte TITLECASE_LETTER = 11;
    public static final byte UPPERCASE_LETTER = 12;
    public static final byte MARK = 13;
    public static final byte SPACING_MARK = 14;
    public static final byte ENCLOSING_MARK = 15;
    public static final byte NONSPACING_MARK = 16;
    public static final byte NUMBER = 17;
    public static final byte DECIMAL_NUMBER = 18;
    public static final byte LETTER_NUMBER = 19;
    public static final byte OTHER_NUMBER = 20;
    public static final byte PUNCTUATION = 21;
    public static final byte CONNECTOR_PUNCTUATION = 22;
    public static final byte DASH_PUNCTUATION = 23;
    public static final byte CLOSE_PUNCTUATION = 24;
    public static final byte FINAL_PUNCTUATION = 25;
    public static final byte INITIAL_PUNCTUATION = 26;
    public static final byte OTHER_PUNCTUATION = 27;
    public static final byte OPEN_PUNCTUATION = 28;
    public static final byte SYMBOL = 29;
    public static final byte CURRENCY_SYMBOL = 30;
    public static final byte MODIFIER_SYMBOL = 31;
    public static final byte MATH_SYMBOL = 32;
    public static final byte OTHER_SYMBOL = 33;
    public static final byte SEPARATOR = 34;
    public static final byte LINE_SEPARATOR = 35;
    public static final byte PARAGRAPH_SEPARATOR = 36;
    public static final byte SPACE_SEPARATOR = 37;
    public static final byte TRUE = 38;
    public static final byte FALSE = 39;
    public static final Map<String, Byte> PROPERTY_NAMES = Map.ofEntries(Map.entry("Alphabetic", (byte)1), Map.entry("Alpha", (byte)1), Map.entry("ASCII", (byte)2), Map.entry("Case_Ignorable", (byte)3), Map.entry("CI", (byte)3), Map.entry("General_Category", (byte)11), Map.entry("gc", (byte)11), Map.entry("Script", (byte)12), Map.entry("sc", (byte)12), Map.entry("ASCII_Hex_Digit", (byte)4), Map.entry("AHex", (byte)4), Map.entry("Hex_Digit", (byte)5), Map.entry("Hex", (byte)5), Map.entry("ID_Continue", (byte)6), Map.entry("IDC", (byte)6), Map.entry("ID_Start", (byte)7), Map.entry("IDS", (byte)7), Map.entry("Lowercase", (byte)8), Map.entry("Lower", (byte)8), Map.entry("Uppercase", (byte)9), Map.entry("Upper", (byte)9), Map.entry("White_Space", (byte)10), Map.entry("space", (byte)10));
    public static final Map<String, Byte> PROPERTY_VALUES = Map.ofEntries(Map.entry("Other", (byte)1), Map.entry("C", (byte)1), Map.entry("Control", (byte)2), Map.entry("Cc", (byte)2), Map.entry("cntrl", (byte)2), Map.entry("Format", (byte)3), Map.entry("Cf", (byte)3), Map.entry("Unassigned", (byte)4), Map.entry("Cn", (byte)4), Map.entry("Private_Use", (byte)5), Map.entry("Co", (byte)5), Map.entry("Surrogate", (byte)6), Map.entry("Cs", (byte)6), Map.entry("Letter", (byte)7), Map.entry("L", (byte)7), Map.entry("Lowercase_Letter", (byte)8), Map.entry("Ll", (byte)8), Map.entry("Modifier_Letter", (byte)9), Map.entry("Lm", (byte)9), Map.entry("Other_Letter", (byte)10), Map.entry("Lo", (byte)10), Map.entry("Titlecase_Letter", (byte)11), Map.entry("Lt", (byte)11), Map.entry("Uppercase_Letter", (byte)12), Map.entry("Lu", (byte)12), Map.entry("Mark", (byte)13), Map.entry("M", (byte)13), Map.entry("Combining_Mark", (byte)13), Map.entry("Spacing_Mark", (byte)14), Map.entry("Mc", (byte)14), Map.entry("Enclosing_Mark", (byte)15), Map.entry("Me", (byte)15), Map.entry("Nonspacing_Mark", (byte)16), Map.entry("Mn", (byte)16), Map.entry("Number", (byte)17), Map.entry("N", (byte)17), Map.entry("Decimal_Number", (byte)18), Map.entry("Nd", (byte)18), Map.entry("digit", (byte)17), Map.entry("Letter_Number", (byte)19), Map.entry("Nl", (byte)19), Map.entry("Other_Number", (byte)20), Map.entry("No", (byte)20), Map.entry("Punctuation", (byte)21), Map.entry("P", (byte)21), Map.entry("punct", (byte)21), Map.entry("Connector_Punctuation", (byte)22), Map.entry("Pc", (byte)22), Map.entry("Dash_Punctuation", (byte)23), Map.entry("Pd", (byte)23), Map.entry("Close_Punctuation", (byte)24), Map.entry("Pe", (byte)24), Map.entry("Final_Punctuation", (byte)25), Map.entry("Pf", (byte)25), Map.entry("Initial_Punctuation", (byte)26), Map.entry("Pi", (byte)26), Map.entry("Other_Punctuation", (byte)27), Map.entry("Po", (byte)27), Map.entry("Open_Punctuation", (byte)28), Map.entry("Ps", (byte)28), Map.entry("Symbol", (byte)29), Map.entry("S", (byte)29), Map.entry("Currency_Symbol", (byte)30), Map.entry("Sc", (byte)30), Map.entry("Modifier_Symbol", (byte)31), Map.entry("Sk", (byte)31), Map.entry("Math_Symbol", (byte)32), Map.entry("Sm", (byte)32), Map.entry("Other_Symbol", (byte)33), Map.entry("So", (byte)33), Map.entry("Separator", (byte)34), Map.entry("Z", (byte)34), Map.entry("Line_Separator", (byte)35), Map.entry("Zl", (byte)35), Map.entry("Paragraph_Separator", (byte)36), Map.entry("Zp", (byte)36), Map.entry("Space_Separator", (byte)37), Map.entry("Zs", (byte)37));
    private static final Character.UnicodeScript[] UnicodeScriptValues = Character.UnicodeScript.values();

    public static int lookup(String propertyOrValue) {
        if (propertyOrValue == null || propertyOrValue.isEmpty()) {
            return -1;
        }
        Matcher m = Pattern.compile("^(?<propName>[a-zA-Z_]+)(?:=(?<propValue>[a-zA-Z_0-9]+))?$").matcher(propertyOrValue);
        m.find();
        if (!m.matches() || m.group("propName") == null) {
            return -1;
        }
        if (m.group("propValue") == null) {
            String property = m.group("propName");
            Byte propByte = PROPERTY_NAMES.get(property);
            if (propByte == null) {
                Byte valueByte = PROPERTY_VALUES.get(property);
                if (valueByte != null) {
                    return UnicodeProperties.encodeProperty((byte)11, valueByte);
                }
                return -1;
            }
            if (propByte == 11 || propByte == 12) {
                return -1;
            }
            return UnicodeProperties.encodeProperty(propByte, (byte)38);
        }
        String property = m.group("propName");
        String value = m.group("propValue");
        Byte propByte = PROPERTY_NAMES.get(property);
        if (propByte == null) {
            return -1;
        }
        switch (propByte) {
            case 11: {
                Byte valueByte = PROPERTY_VALUES.get(value);
                if (valueByte == null) {
                    return -1;
                }
                return UnicodeProperties.encodeProperty((byte)11, valueByte);
            }
            case 12: {
                try {
                    return UnicodeProperties.encodeProperty((byte)12, (byte)Character.UnicodeScript.forName(value).ordinal());
                }
                catch (IllegalArgumentException e) {
                    return -1;
                }
            }
        }
        return -1;
    }

    private static int encodeProperty(byte property, byte value) {
        return (property & 0xFF) << 8 | value & 0xFF;
    }

    public static boolean hasProperty(int property, int codePoint) {
        byte propByte = (byte)(property >> 8 & 0xFF);
        int valueByte = property & 0xFF;
        switch (propByte) {
            case 1: {
                return Character.isAlphabetic(codePoint) == (valueByte == 38);
            }
            case 2: {
                return codePoint <= 127 == (valueByte == 38);
            }
            case 3: {
                return (Character.getType(codePoint) == 27 || Character.getType(codePoint) == 4 || Character.getType(codePoint) == 6) == (valueByte == 38);
            }
            case 11: {
                int javaCategory = Character.getType(codePoint);
                return UnicodeProperties.checkGeneralCategory(valueByte, javaCategory);
            }
            case 4: {
                return UnicodeProperties.isHexDigit(codePoint) == (valueByte == 38);
            }
            case 5: {
                return Character.digit(codePoint, 16) != -1 == (valueByte == 38);
            }
            case 6: {
                return Character.isUnicodeIdentifierPart(codePoint) == (valueByte == 38);
            }
            case 7: {
                return Character.isUnicodeIdentifierStart(codePoint) == (valueByte == 38);
            }
            case 8: {
                return Character.isLowerCase(codePoint) == (valueByte == 38);
            }
            case 9: {
                return Character.isUpperCase(codePoint) == (valueByte == 38);
            }
            case 10: {
                return valueByte == 38 == (Character.isSpaceChar(codePoint) || Character.isWhitespace(codePoint));
            }
            case 12: {
                return Character.UnicodeScript.of(codePoint) == UnicodeScriptValues[valueByte];
            }
        }
        return false;
    }

    private static boolean checkGeneralCategory(int propertyValueByte, int javaCategory) {
        switch (propertyValueByte) {
            case 7: {
                return javaCategory == 1 || javaCategory == 2 || javaCategory == 3 || javaCategory == 4 || javaCategory == 5;
            }
            case 12: {
                return javaCategory == 1;
            }
            case 8: {
                return javaCategory == 2;
            }
            case 11: {
                return javaCategory == 3;
            }
            case 9: {
                return javaCategory == 4;
            }
            case 10: {
                return javaCategory == 5;
            }
            case 13: {
                return javaCategory == 6 || javaCategory == 7 || javaCategory == 8;
            }
            case 16: {
                return javaCategory == 6;
            }
            case 15: {
                return javaCategory == 7;
            }
            case 14: {
                return javaCategory == 8;
            }
            case 17: {
                return javaCategory == 9 || javaCategory == 10 || javaCategory == 11;
            }
            case 18: {
                return javaCategory == 9;
            }
            case 19: {
                return javaCategory == 10;
            }
            case 20: {
                return javaCategory == 11;
            }
            case 34: {
                return javaCategory == 12 || javaCategory == 13 || javaCategory == 14;
            }
            case 37: {
                return javaCategory == 12;
            }
            case 35: {
                return javaCategory == 13;
            }
            case 36: {
                return javaCategory == 14;
            }
            case 1: {
                return javaCategory == 5 || javaCategory == 11 || javaCategory == 24 || javaCategory == 28;
            }
            case 2: {
                return javaCategory == 15;
            }
            case 3: {
                return javaCategory == 16;
            }
            case 6: {
                return javaCategory == 19;
            }
            case 5: {
                return javaCategory == 18;
            }
            case 21: {
                return javaCategory == 23 || javaCategory == 20 || javaCategory == 21 || javaCategory == 22 || javaCategory == 24 || javaCategory == 29 || javaCategory == 30;
            }
            case 23: {
                return javaCategory == 20;
            }
            case 28: {
                return javaCategory == 21;
            }
            case 24: {
                return javaCategory == 22;
            }
            case 22: {
                return javaCategory == 23;
            }
            case 27: {
                return javaCategory == 24;
            }
            case 26: {
                return javaCategory == 29;
            }
            case 25: {
                return javaCategory == 30;
            }
            case 29: {
                return javaCategory == 25 || javaCategory == 26 || javaCategory == 27 || javaCategory == 28;
            }
            case 32: {
                return javaCategory == 25;
            }
            case 30: {
                return javaCategory == 26;
            }
            case 31: {
                return javaCategory == 27;
            }
            case 33: {
                return javaCategory == 28;
            }
            case 4: {
                return javaCategory == 0;
            }
        }
        return false;
    }

    private static boolean isHexDigit(int codePoint) {
        return codePoint >= 48 && codePoint <= 57 || codePoint >= 97 && codePoint <= 102 || codePoint >= 65 && codePoint <= 70;
    }
}

