/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.processors.parsers;

import org.apache.daffodil.io.InputSourceDataInputStream;
import org.apache.daffodil.io.processors.charset.BitsCharset;
import org.apache.daffodil.io.processors.charset.BitsCharsetDecoderUnalignedCharDecodeException;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.util.Maybe$;
import org.apache.daffodil.lib.util.MaybeInt$;
import org.apache.daffodil.lib.util.MaybeULong$;
import org.apache.daffodil.runtime1.processors.TextJustificationType;
import org.apache.daffodil.runtime1.processors.TextJustificationType$None$;
import org.apache.daffodil.runtime1.processors.parsers.CaptureParsingValueLength;
import org.apache.daffodil.runtime1.processors.parsers.CharsetNotByteAlignedError;
import org.apache.daffodil.runtime1.processors.parsers.PState;
import org.apache.daffodil.runtime1.processors.parsers.PaddingRuntimeMixin;
import passera.unsigned.ULong$;
import scala.Int$;
import scala.math.package$;

public interface StringOfSpecifiedLengthMixin
extends PaddingRuntimeMixin,
CaptureParsingValueLength {
    public static String parseString$(StringOfSpecifiedLengthMixin $this, PState start) {
        return $this.parseString(start);
    }

    default public String parseString(PState start) {
        Object object;
        InputSourceDataInputStream dis = start.dataInputStream();
        long startBitPos0b = dis.bitPos0b();
        long bitLimit0b = dis.bitLimit0b();
        if (!MaybeULong$.MODULE$.isDefined$extension(bitLimit0b)) {
            throw Assert$.MODULE$.abort("Invariant broken: bitLimit0b.isDefined");
        }
        long availableBits = MaybeULong$.MODULE$.get$extension(bitLimit0b) - startBitPos0b;
        BitsCharset charset = (BitsCharset)this.charsetEv().evaluate(start);
        long optWidth = charset.maybeFixedWidth();
        int bitsPerChar = MaybeInt$.MODULE$.isDefined$extension(optWidth) ? MaybeInt$.MODULE$.get$extension(optWidth) : charset.bitWidthOfACodeUnit();
        long maxPossibleChars = availableBits / (long)bitsPerChar + 1L;
        long maxLen = package$.MODULE$.min(maxPossibleChars, Int$.MODULE$.int2long(start.tunable().maximumSimpleElementSizeInCharacters()));
        try {
            object = dis.getSomeString(maxLen, start);
        }
        catch (BitsCharsetDecoderUnalignedCharDecodeException e) {
            throw new CharsetNotByteAlignedError(start, e);
        }
        Object strOpt = object;
        String str = Maybe$.MODULE$.isDefined$extension(strOpt) ? (String)Maybe$.MODULE$.get$extension(strOpt) : "";
        String field = this.trimByJustification(str);
        TextJustificationType.Type type = this.justificationTrim();
        if (TextJustificationType$None$.MODULE$.equals(type)) {
            this.captureValueLength(start, ULong$.MODULE$.apply(startBitPos0b), ULong$.MODULE$.apply(dis.bitPos0b()));
        } else {
            this.captureValueLengthOfString(start, field);
        }
        return field;
    }
}

