/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.unparsers.runtime1;

import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.daffodil.io.DirectOrBufferedDataOutputStream;
import org.apache.daffodil.lib.util.Maybe$One$;
import org.apache.daffodil.runtime1.infoset.DISimple;
import org.apache.daffodil.runtime1.infoset.DataValue$;
import org.apache.daffodil.runtime1.processors.ElementRuntimeData;
import org.apache.daffodil.runtime1.processors.Evaluatable;
import org.apache.daffodil.runtime1.processors.PrimProcessor;
import org.apache.daffodil.runtime1.processors.Processor;
import org.apache.daffodil.runtime1.processors.ToBriefXMLImpl;
import org.apache.daffodil.runtime1.processors.unparsers.PrimUnparser;
import org.apache.daffodil.runtime1.processors.unparsers.UState;
import org.apache.daffodil.runtime1.processors.unparsers.UnparseError$;
import org.apache.daffodil.runtime1.processors.unparsers.Unparser;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public abstract class BlobUnparserBase
implements ToBriefXMLImpl,
Processor,
Unparser,
PrimProcessor,
PrimUnparser {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(BlobUnparserBase.class.getDeclaredField("org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzy1"));
    private volatile Object org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzy1;
    private boolean isInitialized;
    private final ElementRuntimeData context;

    public BlobUnparserBase(ElementRuntimeData context) {
        this.context = context;
        ToBriefXMLImpl.$init$(this);
        Processor.$init$(this);
    }

    @Override
    public String org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_() {
        Object object = this.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzyINIT1();
    }

    private Object org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = ToBriefXMLImpl.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$(this);
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Override
    public void isInitialized_$eq(boolean x$1) {
        this.isInitialized = x$1;
    }

    @Override
    public ElementRuntimeData context() {
        return this.context;
    }

    @Override
    public Vector<Evaluatable<Object>> runtimeDependencies() {
        return (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
    }

    public abstract long getLengthInBits(UState var1);

    @Override
    public void unparse(UState state) {
        long l;
        DISimple node = state.currentInfosetNode().asSimple();
        Object object = node.dataValue();
        URI value = DataValue$.MODULE$.getURI$extension(object);
        long lengthInBits = this.getLengthInBits(state);
        long lengthInBytes = (lengthInBits + 7L) / 8L;
        String uriScheme = value.getScheme();
        String uriPath = value.getPath();
        String string = uriScheme;
        String string2 = "file";
        if (string == null ? string2 != null : !string.equals(string2)) {
            throw UnparseError$.MODULE$.apply(Maybe$One$.MODULE$.apply(this.context().schemaFileLocation()), Maybe$One$.MODULE$.apply(state.currentLocation()), "Blob URI must be a file: %s", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{value.toString()}));
        }
        Path path = Paths.get(value);
        try {
            l = Files.size(path);
        }
        catch (Exception e) {
            throw UnparseError$.MODULE$.apply(Maybe$One$.MODULE$.apply(this.context().schemaFileLocation()), Maybe$One$.MODULE$.apply(state.currentLocation()), "Unable to open blob for reading: %s", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{value.toString()}));
        }
        long fileSizeInBytes = l;
        if (fileSizeInBytes > lengthInBytes) {
            throw UnparseError$.MODULE$.apply(Maybe$One$.MODULE$.apply(this.context().schemaFileLocation()), Maybe$One$.MODULE$.apply(state.currentLocation()), "Blob length (%d bits) exceeds explicit length value: %d bits", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(fileSizeInBytes * 8L)), BoxesRunTime.boxToLong((long)lengthInBits)}));
        }
        DirectOrBufferedDataOutputStream dos = state.getDataOutputStream();
        DirectOrBufferedDataOutputStream newStream = dos.addBufferedBlob(path, lengthInBits, state.tunable().blobChunkSizeInBytes(), state);
        state.setDataOutputStream(newStream);
        dos.setFinished(state);
    }
}

