// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

package org.apache.doris.nereids.trees.expressions.functions.agg;

import org.apache.doris.catalog.FunctionSignature;
import org.apache.doris.nereids.trees.expressions.Expression;
import org.apache.doris.nereids.trees.expressions.functions.ExplicitlyCastableSignature;
import org.apache.doris.nereids.trees.expressions.shape.BinaryExpression;
import org.apache.doris.nereids.trees.expressions.visitor.ExpressionVisitor;
import org.apache.doris.nereids.types.DoubleType;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;

import java.util.List;

/**
 * AggregateFunction 'corr_welford'. This class is generated by GenerateFunction.
 */
public class CorrWelford extends NullableAggregateFunction
        implements BinaryExpression, ExplicitlyCastableSignature {

    public static final List<FunctionSignature> SIGNATURES = ImmutableList.of(
            FunctionSignature.ret(DoubleType.INSTANCE).args(DoubleType.INSTANCE, DoubleType.INSTANCE)
    );

    /**
     * constructor with 2 argument.
     */
    public CorrWelford(Expression arg1, Expression arg2) {
        this(false, arg1, arg2);
    }

    /**
     * constructor with 3 arguments.
     */
    public CorrWelford(boolean distinct, Expression arg1, Expression arg2) {
        this(distinct, false, arg1, arg2);
    }

    public CorrWelford(boolean distinct, boolean alwaysNullable, Expression arg1, Expression arg2) {
        super("corr_welford", distinct, alwaysNullable, arg1, arg2);
    }

    /** constructor for withChildren and reuse signature */
    private CorrWelford(NullableAggregateFunctionParams functionParams) {
        super(functionParams);
    }

    /**
     * withDistinctAndChildren.
     */
    @Override
    public CorrWelford withDistinctAndChildren(boolean distinct, List<Expression> children) {
        Preconditions.checkArgument(children.size() == 2);
        return new CorrWelford(getFunctionParams(distinct, children));
    }

    @Override
    public CorrWelford withAlwaysNullable(boolean alwaysNullable) {
        return new CorrWelford(getAlwaysNullableFunctionParams(alwaysNullable));
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitCorrWelford(this, context);
    }

    @Override
    public List<FunctionSignature> getSignatures() {
        return SIGNATURES;
    }
}
