/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.dbms.mysql;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.validation.DBModelParser;

public class MySQLDBModelParser
extends DBModelParser {
    public MySQLDBModelParser(String catalog, String schemaPattern) {
        super(catalog, schemaPattern);
    }

    @Override
    protected double getColumnSize(DataType empireType, ResultSet rs) throws SQLException {
        switch (empireType) {
            case INTEGER: {
                int sqlType = rs.getInt("DATA_TYPE");
                switch (sqlType) {
                    case -6: {
                        return 1.0;
                    }
                    case 5: {
                        return 2.0;
                    }
                    case -5: {
                        return 8.0;
                    }
                }
                return 4.0;
            }
        }
        return super.getColumnSize(empireType, rs);
    }

    @Override
    protected Object getColumnDefault(ResultSet rs) throws SQLException {
        String defaultValue = rs.getString("COLUMN_DEF");
        if (defaultValue != null && defaultValue.equals("CURRENT_TIMESTAMP")) {
            return DBDatabase.SYSDATE;
        }
        return defaultValue;
    }

    @Override
    protected boolean isIdentityColumn(ResultSet rs) {
        try {
            int i = rs.findColumn("IS_AUTOINCREMENT");
            return rs.getString(i).equalsIgnoreCase("YES");
        }
        catch (SQLException e) {
            log.warn("Missing column IS_AUTOINCREMENT. Unable to detect Identity column");
            return false;
        }
    }

    @Override
    protected boolean isTimestampColumn(ResultSet rs) {
        try {
            String defaultValue = rs.getString("COLUMN_DEF");
            if (rs.getInt("DATA_TYPE") == 93 && defaultValue != null && defaultValue.equals("CURRENT_TIMESTAMP")) {
                return true;
            }
            return super.isTimestampColumn(rs);
        }
        catch (SQLException e) {
            log.warn("Missing column COLUMN_DEF. Unable to detect Timestamp column");
            return false;
        }
    }
}

