/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.data.bean;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBContext;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBObject;
import org.apache.empire.db.DBReader;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.exceptions.CommandWithoutSelectException;
import org.apache.empire.exceptions.BeanIncompatibleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanResult<T>
extends ArrayList<T> {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(BeanResult.class);
    private DBCommand cmd;
    private Class<T> beanType;

    public BeanResult(Class<T> beanType, DBCommand cmd) {
        DBObject.checkParamNull("beanType", beanType);
        DBObject.checkParamNull("cmd", cmd);
        this.beanType = beanType;
        this.cmd = cmd;
    }

    public BeanResult(Class<T> beanType, DBRowSet rowset) {
        DBObject.checkParamNull("beanType", beanType);
        DBObject.checkParamNull("rowset", rowset);
        this.beanType = beanType;
        DBDatabase db = rowset.getDatabase();
        this.cmd = db.createCommand();
        this.autoSelectColumns(rowset);
    }

    public DBCommand getCommand() {
        return this.cmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int fetch(DBContext context, int maxItems) {
        if (!this.cmd.hasSelectExpr()) {
            throw new CommandWithoutSelectException(this.cmd);
        }
        this.clear();
        try (DBReader reader = new DBReader(context);){
            reader.open(this.cmd);
            reader.getBeanList(this, this.beanType, null, maxItems);
            int n = this.size();
            return n;
        }
    }

    public final int fetch(DBContext context) {
        return this.fetch(context, -1);
    }

    protected void autoSelectColumns(DBRowSet rowset) {
        int count = 0;
        Method[] methods = this.beanType.getMethods();
        for (DBColumn col : rowset.getColumns()) {
            String property = col.getBeanPropertyName();
            if (!this.isPropertyAcessible(methods, property, col.getDataType())) {
                log.info("Unable to access the property {} on {}. Column will be ignored.", (Object)property, (Object)this.beanType.getName());
                continue;
            }
            this.cmd.select((DBColumnExpr)col);
            ++count;
        }
        log.debug("{} columns have been selected for beanType {}", (Object)count, (Object)this.beanType.getName());
        if (count == 0) {
            throw new BeanIncompatibleException(this.beanType, rowset);
        }
    }

    protected boolean isPropertyAcessible(Method[] methods, String property, DataType dataType) {
        String prefix = dataType.isBoolean() ? "is" : "et";
        String getter = prefix + property.substring(0, 1).toUpperCase() + property.substring(1);
        for (int i = 0; i < methods.length; ++i) {
            String name = methods[i].getName();
            if (!name.endsWith(getter)) continue;
            return true;
        }
        return false;
    }
}

