/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCommandExpr;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBIndex;
import org.apache.empire.db.DBObject;
import org.apache.empire.db.DBRelation;
import org.apache.empire.db.DBSQLBuilder;
import org.apache.empire.db.DBSQLScript;
import org.apache.empire.db.DBTable;
import org.apache.empire.db.DBTableColumn;
import org.apache.empire.db.DBView;
import org.apache.empire.dbms.DBMSHandler;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.InvalidOperationException;
import org.apache.empire.exceptions.NotImplementedException;
import org.apache.empire.exceptions.NotSupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DBDDLGenerator<T extends DBMSHandler> {
    protected static final Logger log = LoggerFactory.getLogger(DBDDLGenerator.class);
    protected final T dbms;
    protected String DATATYPE_INT_SMALL = "SMALLINT";
    protected String DATATYPE_INTEGER = "INT";
    protected String DATATYPE_INT_BIG = "BIGINT";
    protected String DATATYPE_CHAR = "CHAR";
    protected String DATATYPE_VARCHAR = "VARCHAR";
    protected String DATATYPE_DATE = "DATE";
    protected String DATATYPE_TIME = "TIME";
    protected String DATATYPE_DATETIME = "TIMESTAMP";
    protected String DATATYPE_TIMESTAMP = "TIMESTAMP";
    protected String DATATYPE_BOOLEAN = "BIT";
    protected String DATATYPE_DECIMAL = "DECIMAL";
    protected String DATATYPE_FLOAT = "FLOAT";
    protected String DATATYPE_CLOB = "CLOB";
    protected String DATATYPE_BLOB = "BLOB";
    protected String DATATYPE_UNIQUEID = "CHAR(36)";
    protected boolean namePrimaryKeyConstraint = true;
    protected String alterColumnPhrase = " ALTER ";
    protected String databaseObjectName = "DATABASE";
    protected boolean ddlColumnDefaults = false;

    protected DBDDLGenerator(T dbmsHandler) {
        this.dbms = dbmsHandler;
    }

    public boolean isDDLColumnDefaults() {
        return this.ddlColumnDefaults;
    }

    public void setDDLColumnDefaults(boolean ddlColumnDefaults) {
        this.ddlColumnDefaults = ddlColumnDefaults;
    }

    protected void addCreateTableStmt(DBTable table, DBSQLBuilder sql, DBSQLScript script) {
        log.info("Adding create statmement for table {}.", (Object)table.getName());
        script.addStmt(sql);
    }

    protected void addCreateIndexStmt(DBIndex index, DBSQLBuilder sql, DBSQLScript script) {
        log.info("Adding create statmement for index {}.", (Object)index.getName());
        script.addStmt(sql);
    }

    protected void addCreateRelationStmt(DBRelation rel, DBSQLBuilder sql, DBSQLScript script) {
        log.info("Adding create statmement for relation {}.", (Object)rel.getName());
        script.addStmt(sql);
    }

    protected void addCreateViewStmt(DBView v, DBSQLBuilder sql, DBSQLScript script) {
        log.info("Adding create statmement for view {}.", (Object)v.getName());
        script.addStmt(sql);
    }

    protected void addAlterTableStmt(DBColumn col, DBSQLBuilder sql, DBSQLScript script) {
        log.info("Adding alter statmement for column {}.", (Object)col.getFullName());
        script.addStmt(sql);
    }

    protected boolean appendColumnDataType(DataType type, double size, DBTableColumn c, DBSQLBuilder sql) {
        switch (type) {
            case INTEGER: 
            case AUTOINC: {
                int bytes = Math.abs((int)size);
                if (bytes > 0 && bytes < 3) {
                    sql.append(this.DATATYPE_INT_SMALL);
                    break;
                }
                if (bytes > 4) {
                    sql.append(this.DATATYPE_INT_BIG);
                    break;
                }
                sql.append(this.DATATYPE_INTEGER);
                break;
            }
            case VARCHAR: 
            case CHAR: {
                sql.append(type == DataType.CHAR ? this.DATATYPE_CHAR : this.DATATYPE_VARCHAR);
                int len = Math.abs((int)size);
                if (len == 0) {
                    len = type == DataType.CHAR ? 1 : 100;
                }
                sql.append("(");
                sql.append(String.valueOf(len));
                sql.append(")");
                break;
            }
            case DATE: {
                sql.append(this.DATATYPE_DATE);
                break;
            }
            case TIME: {
                sql.append(this.DATATYPE_TIME);
                break;
            }
            case DATETIME: {
                sql.append(this.DATATYPE_DATETIME);
                break;
            }
            case TIMESTAMP: {
                sql.append(this.DATATYPE_TIMESTAMP);
                break;
            }
            case BOOL: {
                sql.append(this.DATATYPE_BOOLEAN);
                break;
            }
            case FLOAT: {
                sql.append(this.DATATYPE_FLOAT);
                int prec = Math.abs((int)size);
                if (prec <= 0) break;
                sql.append("(");
                sql.append(String.valueOf(prec));
                sql.append(")");
                break;
            }
            case DECIMAL: {
                sql.append(this.DATATYPE_DECIMAL);
                int prec = (int)size;
                int scale = c.getDecimalScale();
                if (prec <= 0) break;
                sql.append("(");
                sql.append(String.valueOf(prec));
                sql.append(",");
                sql.append(String.valueOf(scale));
                sql.append(")");
                break;
            }
            case CLOB: {
                sql.append(this.DATATYPE_CLOB);
                break;
            }
            case BLOB: {
                sql.append(this.DATATYPE_BLOB);
                if (!(size > 0.0)) break;
                sql.append("(").append((long)size).append(") ");
                break;
            }
            case UNIQUEID: {
                sql.append(this.DATATYPE_UNIQUEID);
                break;
            }
            default: {
                throw new InvalidOperationException("Error: Unable to append column of type UNKNOWN");
            }
        }
        return true;
    }

    protected void appendColumnDesc(DBTableColumn c, boolean alter, DBSQLBuilder sql) {
        c.addSQL(sql, 1L);
        sql.append(" ");
        if (!this.appendColumnDataType(c.getDataType(), c.getSize(), c, sql)) {
            return;
        }
        if (this.isDDLColumnDefaults() && !c.isAutoGenerated() && c.getDefaultValue() != null) {
            sql.append(" DEFAULT ");
            sql.appendValue(c.getDataType(), c.getDefaultValue());
        }
        if (c.isRequired() || c.isAutoGenerated()) {
            sql.append(" NOT NULL");
        }
    }

    protected void appendIndexColumn(DBIndex index, DBColumnExpr idxColumn, DBSQLBuilder sql) {
        idxColumn.addSQL(sql, 1L);
    }

    protected void appendIndexType(DBIndex index, DBSQLBuilder sql) {
        if (index.getType().isUnique()) {
            sql.append("UNIQUE ");
        }
    }

    public void getDDLScript(DDLActionType type, DBObject dbo, DBSQLScript script) {
        if (dbo == null || ((DBDatabase)dbo.getDatabase()).getDbms() != this.dbms) {
            throw new InvalidArgumentException("dbo", dbo);
        }
        String schema = ((DBDatabase)dbo.getDatabase()).getSchema();
        if (dbo instanceof DBDatabase) {
            switch (type) {
                case CREATE: {
                    this.createDatabase((DBDatabase)dbo, script);
                    return;
                }
                case DROP: {
                    this.dropObject(null, schema, this.databaseObjectName, script);
                    return;
                }
            }
            throw new NotImplementedException(this, "getDDLScript." + dbo.getClass().getName() + "." + (Object)((Object)type));
        }
        if (dbo instanceof DBTable) {
            switch (type) {
                case CREATE: {
                    this.createTable((DBTable)dbo, script);
                    return;
                }
                case DROP: {
                    this.dropObject(schema, ((DBTable)dbo).getName(), "TABLE", script);
                    return;
                }
            }
            throw new NotImplementedException(this, "getDDLScript." + dbo.getClass().getName() + "." + (Object)((Object)type));
        }
        if (dbo instanceof DBView) {
            switch (type) {
                case CREATE: {
                    this.createView((DBView)dbo, script);
                    return;
                }
                case DROP: {
                    this.dropObject(schema, ((DBView)dbo).getName(), "VIEW", script);
                    return;
                }
                case ALTER: {
                    this.dropObject(schema, ((DBView)dbo).getName(), "VIEW", script);
                    this.createView((DBView)dbo, script);
                    return;
                }
            }
            throw new NotImplementedException(this, "getDDLScript." + dbo.getClass().getName() + "." + (Object)((Object)type));
        }
        if (dbo instanceof DBRelation) {
            switch (type) {
                case CREATE: {
                    this.createRelation((DBRelation)dbo, script);
                    return;
                }
                case DROP: {
                    this.dropObject(schema, ((DBRelation)dbo).getName(), "CONSTRAINT", script);
                    return;
                }
            }
            throw new NotImplementedException(this, "getDDLScript." + dbo.getClass().getName() + "." + (Object)((Object)type));
        }
        if (dbo instanceof DBIndex) {
            switch (type) {
                case CREATE: {
                    this.createIndex(((DBIndex)dbo).getTable(), (DBIndex)dbo, script);
                    return;
                }
                case DROP: {
                    this.dropObject(schema, ((DBIndex)dbo).getName(), "INDEX", script);
                    return;
                }
            }
            throw new NotImplementedException(this, "getDDLScript." + dbo.getClass().getName() + "." + (Object)((Object)type));
        }
        if (!(dbo instanceof DBTableColumn)) {
            throw new NotSupportedException(this, "getDDLScript() for " + dbo.getClass().getName());
        }
        this.alterTable((DBTableColumn)dbo, type, script);
    }

    protected void createDatabase(DBDatabase db, DBSQLScript script) {
        for (DBTable dbTable : db.getTables()) {
            this.createTable(dbTable, script);
        }
        for (DBRelation dbRelation : db.getRelations()) {
            this.createRelation(dbRelation, script);
        }
        for (DBView v : db.getViews()) {
            try {
                this.createView(v, script);
            }
            catch (NotSupportedException e) {
                log.warn("Error creating the view {0}. This view will be ignored.", (Object)v.getName());
            }
        }
    }

    protected void dropDatabase(DBDatabase db, DBSQLScript script) {
        this.dropObject(null, db.getSchema(), "DATABASE", script);
    }

    protected void createTable(DBTable t, DBSQLScript script) {
        DBSQLBuilder sql = this.dbms.createSQLBuilder();
        sql.append("-- creating table ");
        sql.append(t.getName());
        sql.append(" --\r\n");
        sql.append("CREATE TABLE ");
        t.addSQL(sql, 2L);
        sql.append(" (");
        boolean addSeparator = false;
        for (DBColumn dbColumn : t.getColumns()) {
            DBTableColumn c = (DBTableColumn)dbColumn;
            if (c.getDataType() == DataType.UNKNOWN) continue;
            sql.append(addSeparator ? ",\r\n   " : "\r\n   ");
            this.appendColumnDesc(c, false, sql);
            addSeparator = true;
        }
        DBIndex pk = t.getPrimaryKey();
        if (pk != null) {
            DBColumn[] keyColumns;
            sql.append(",\r\n");
            if (this.namePrimaryKeyConstraint) {
                sql.append(" CONSTRAINT ");
                this.appendElementName(sql, pk.getName());
            }
            sql.append(" PRIMARY KEY (");
            addSeparator = false;
            for (DBColumn keyColumn : keyColumns = pk.getColumns()) {
                sql.append(addSeparator ? ", " : "");
                keyColumn.addSQL(sql, 1L);
                addSeparator = true;
            }
            sql.append(")");
        }
        sql.append(")");
        this.addCreateTableStmt(t, sql, script);
        this.createTableIndexes(t, pk, script);
    }

    protected void createTableIndexes(DBTable t, DBIndex pk, DBSQLScript script) {
        for (DBIndex idx : t.getIndexes()) {
            if (idx == pk || idx.getType() == DBIndex.DBIndexType.PRIMARY_KEY) continue;
            this.createIndex(t, idx, script);
        }
    }

    protected void createIndex(DBTable t, DBIndex index, DBSQLScript script) {
        DBColumnExpr[] idxColumns;
        DBSQLBuilder sql = this.dbms.createSQLBuilder();
        sql.append("CREATE ");
        this.appendIndexType(index, sql);
        sql.append("INDEX ");
        this.appendElementName(sql, index.getName());
        sql.append(" ON ");
        t.addSQL(sql, 2L);
        sql.append(" (");
        boolean addSeparator = false;
        for (DBColumnExpr idxColumn : idxColumns = index.getExpressions()) {
            sql.append(addSeparator ? ", " : "");
            this.appendIndexColumn(index, idxColumn, sql);
            sql.append("");
            addSeparator = true;
        }
        sql.append(")");
        this.addCreateIndexStmt(index, sql, script);
    }

    protected void createRelation(DBRelation r, DBSQLScript script) {
        DBRelation.DBReference[] refs;
        DBTable sourceTable = (DBTable)r.getReferences()[0].getSourceColumn().getRowSet();
        DBTable targetTable = (DBTable)r.getReferences()[0].getTargetColumn().getRowSet();
        DBSQLBuilder sql = this.dbms.createSQLBuilder();
        sql.append("-- creating foreign key constraint ");
        sql.append(r.getName());
        sql.append(" --\r\n");
        sql.append("ALTER TABLE ");
        sourceTable.addSQL(sql, 2L);
        sql.append(" ADD CONSTRAINT ");
        this.appendElementName(sql, r.getName());
        sql.append(" FOREIGN KEY (");
        boolean addSeparator = false;
        for (DBRelation.DBReference ref1 : refs = r.getReferences()) {
            sql.append(addSeparator ? ", " : "");
            ref1.getSourceColumn().addSQL(sql, 1L);
            addSeparator = true;
        }
        sql.append(") REFERENCES ");
        targetTable.addSQL(sql, 2L);
        sql.append(" (");
        addSeparator = false;
        for (DBRelation.DBReference ref : refs) {
            sql.append(addSeparator ? ", " : "");
            ref.getTargetColumn().addSQL(sql, 1L);
            addSeparator = true;
        }
        sql.append(")");
        if (r.getOnDeleteAction() == DBRelation.DBCascadeAction.CASCADE) {
            sql.append(" ON DELETE CASCADE");
        }
        this.addCreateRelationStmt(r, sql, script);
    }

    protected void alterTable(DBTableColumn col, DDLActionType type, DBSQLScript script) {
        DBSQLBuilder sql = this.dbms.createSQLBuilder();
        sql.append("ALTER TABLE ");
        col.getRowSet().addSQL(sql, 2L);
        switch (type) {
            case CREATE: {
                sql.append(" ADD ");
                this.appendColumnDesc(col, false, sql);
                break;
            }
            case ALTER: {
                sql.append(this.alterColumnPhrase);
                this.appendColumnDesc(col, true, sql);
                break;
            }
            case DROP: {
                sql.append(" DROP COLUMN ");
                sql.append(col.getName());
            }
        }
        this.addAlterTableStmt(col, sql, script);
    }

    protected void createView(DBView v, DBSQLScript script) {
        DBCommandExpr cmd = v.createCommand();
        if (cmd == null) {
            log.error("No command has been supplied for view " + v.getName());
            throw new NotSupportedException(this, v.getName() + ".createCommand");
        }
        cmd.clearOrderBy();
        DBSQLBuilder sql = this.dbms.createSQLBuilder();
        sql.append("CREATE VIEW ");
        v.addSQL(sql, 2L);
        sql.append(" (");
        boolean addSeparator = false;
        for (DBColumn c : v.getColumns()) {
            if (addSeparator) {
                sql.append(", ");
            }
            c.addSQL(sql, 1L);
            addSeparator = true;
        }
        sql.append(")\r\nAS\r\n");
        cmd.addSQL(sql, 23L);
        this.addCreateViewStmt(v, sql, script);
    }

    protected void dropObject(String schema, String name, String objType, DBSQLScript script) {
        if (StringUtils.isEmpty(name)) {
            throw new InvalidArgumentException("name", name);
        }
        DBSQLBuilder sql = this.dbms.createSQLBuilder();
        sql.append("DROP ");
        sql.append(objType);
        sql.append(" ");
        if (StringUtils.isNotEmpty(schema)) {
            sql.append(schema);
            sql.append(".");
        }
        this.appendElementName(sql, name);
        script.addStmt(sql);
    }

    protected void appendElementName(DBSQLBuilder sql, String name) {
        this.dbms.appendObjectName(sql, name, null);
    }

    public static enum DDLActionType {
        CREATE,
        DROP,
        ALTER;

    }
}

