/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.exceptions;

import org.apache.empire.commons.ErrorType;
import org.apache.empire.data.Column;
import org.apache.empire.db.exceptions.FieldValueException;

public class FieldValueOutOfRangeException
extends FieldValueException {
    private static final long serialVersionUID = 1L;
    public static final ErrorType outOfRangeErrorType = new ErrorType("error.db.fieldValueOutOfRange", "The value supplied for field {0} is out of range.");
    public static final ErrorType notInRangeErrorType = new ErrorType("error.db.fieldValueNotInRange", "The value supplied for field {0} must be between {1} and {2}.");
    public static final ErrorType valueTooBigErrorType = new ErrorType("error.db.fieldValueTooBig", "The value supplied for field {0} must not be greater than {1}.");
    public static final ErrorType valueTooSmallErrorType = new ErrorType("error.db.fieldValueTooSmall", "The value supplied for field {0} must not be smaller than {1}.");

    public FieldValueOutOfRangeException(Column col) {
        super(col, outOfRangeErrorType, new String[]{FieldValueOutOfRangeException.getColumnTitle(col)});
    }

    public FieldValueOutOfRangeException(Column col, String min, String max) {
        super(col, notInRangeErrorType, new String[]{FieldValueOutOfRangeException.getColumnTitle(col), String.valueOf(min), String.valueOf(max)});
    }

    public FieldValueOutOfRangeException(Column col, Number min, Number max) {
        this(col, String.valueOf(min), String.valueOf(max));
    }

    public FieldValueOutOfRangeException(Column col, String minMax, boolean isMax) {
        super(col, isMax ? valueTooBigErrorType : valueTooSmallErrorType, new String[]{FieldValueOutOfRangeException.getColumnTitle(col), String.valueOf(minMax)});
    }

    public FieldValueOutOfRangeException(Column col, Number minMax, boolean isMax) {
        this(col, String.valueOf(minMax), isMax);
    }
}

