/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.list;

import java.util.HashMap;
import java.util.Map;
import org.apache.empire.db.list.DBBeanListFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DBBeanFactoryCache {
    protected static final Logger log = LoggerFactory.getLogger(DBBeanFactoryCache.class);
    private static Map<Class<?>, DBBeanListFactory<?>> beanFactoryMap = new HashMap();

    public static void setMapImplementation(Map<Class<?>, DBBeanListFactory<?>> map) {
        beanFactoryMap = map;
    }

    public static synchronized <T> DBBeanListFactory<T> getFactoryForType(Class<T> beanType) {
        DBBeanListFactory<?> factory = beanFactoryMap.get(beanType);
        return factory;
    }

    public static synchronized <T> void setFactoryForType(Class<?> beanType, DBBeanListFactory<T> factory) {
        if (factory != null) {
            DBBeanListFactory<?> prev = beanFactoryMap.get(beanType);
            if (prev != null && prev != factory) {
                log.warn("The Java bean type '{}' has already been assigned to a different BeanListFactory!", (Object)beanType.getName());
            }
            beanFactoryMap.put(beanType, factory);
        } else {
            beanFactoryMap.remove(beanType);
        }
    }
}

