/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.storage.rocketmq.utils;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.api.SendResult;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageAccessor;
import org.apache.rocketmq.common.message.MessageConst;
import org.apache.rocketmq.common.message.MessageExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudEventUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CloudEventUtils.class);

    public static SendResult convertSendResult(org.apache.rocketmq.client.producer.SendResult rmqResult) {
        SendResult sendResult = new SendResult();
        sendResult.setTopic(rmqResult.getMessageQueue().getTopic());
        sendResult.setMessageId(rmqResult.getMsgId());
        return sendResult;
    }

    public static Message msgConvert(MessageExt rmqMsg) {
        Message message = new Message();
        CloudEventUtils.initProperty(rmqMsg, message, Message::getTopic, Message::setTopic);
        CloudEventUtils.initProperty(rmqMsg, message, Message::getKeys, Message::setKeys);
        CloudEventUtils.initProperty(rmqMsg, message, Message::getTags, Message::setTags);
        if (rmqMsg.getBody() != null) {
            message.setBody(rmqMsg.getBody());
        }
        rmqMsg.getProperties().forEach((k, v) -> MessageAccessor.putProperty((Message)message, (String)k, (String)v));
        if (rmqMsg.getMsgId() != null) {
            MessageAccessor.putProperty((Message)message, (String)"messageid", (String)rmqMsg.getMsgId());
        }
        if (rmqMsg.getTopic() != null) {
            MessageAccessor.putProperty((Message)message, (String)"destination", (String)rmqMsg.getTopic());
        }
        MessageAccessor.putProperty((Message)message, (String)"bornhost", (String)String.valueOf(rmqMsg.getBornHost()));
        MessageAccessor.putProperty((Message)message, (String)"borntimestamp", (String)String.valueOf(rmqMsg.getBornTimestamp()));
        MessageAccessor.putProperty((Message)message, (String)"storehost", (String)String.valueOf(rmqMsg.getStoreHost()));
        MessageAccessor.putProperty((Message)message, (String)"storetimestamp", (String)String.valueOf(rmqMsg.getStoreTimestamp()));
        MessageAccessor.putProperty((Message)message, (String)"queueid", (String)String.valueOf(rmqMsg.getQueueId()));
        MessageAccessor.putProperty((Message)message, (String)"queueoffset", (String)String.valueOf(rmqMsg.getQueueOffset()));
        for (String sysPropKey : MessageConst.STRING_HASH_SET) {
            if (!StringUtils.isNotEmpty((CharSequence)message.getProperty(sysPropKey))) continue;
            String prop = message.getProperty(sysPropKey);
            String tmpPropKey = sysPropKey.toLowerCase().replace("_", "99");
            MessageAccessor.putProperty((Message)message, (String)tmpPropKey, (String)prop);
            message.getProperties().remove(sysPropKey);
        }
        return message;
    }

    public static MessageExt msgConvertExt(Message message) {
        MessageExt rmqMessageExt = new MessageExt();
        try {
            CloudEventUtils.initProperty(message, rmqMessageExt, Message::getKeys, Message::setKeys);
            CloudEventUtils.initProperty(message, rmqMessageExt, Message::getTags, Message::setTags);
            if (message.getBody() != null) {
                rmqMessageExt.setBody(message.getBody());
            }
            rmqMessageExt.setTopic(message.getTopic());
            int queueId = Integer.parseInt(message.getProperty("queueid"));
            long queueOffset = Long.parseLong(message.getProperty("queueoffset"));
            rmqMessageExt.setQueueId(queueId);
            rmqMessageExt.setQueueOffset(queueOffset);
            message.getProperties().forEach((k, v) -> MessageAccessor.putProperty((Message)rmqMessageExt, (String)k, (String)v));
        }
        catch (Exception e) {
            log.error("Error with msgConvertExt", (Throwable)e);
        }
        return rmqMessageExt;
    }

    private static <T, V> void initProperty(T source, V target, Function<T, String> function, BiConsumer<V, String> biConsumer) {
        String apply = function.apply(source);
        if (Objects.nonNull(apply)) {
            biConsumer.accept(target, apply);
        }
    }
}

