/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.http.model;

import io.netty.handler.codec.http.HttpMethod;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestParam {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RequestParam.class);
    private Map<String, String[]> queryParams;
    private final HttpMethod httpMethod;
    private Map<String, String> body;
    private Map<String, String> headers;
    private long timeout = 15000L;

    public RequestParam(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public RequestParam setHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public Map<String, String> getBody() {
        return this.body;
    }

    public RequestParam setBody(Map<String, String> body) {
        this.body = body;
        return this;
    }

    public Map<String, String[]> getQueryParamsMap() {
        return this.queryParams;
    }

    public String getQueryParams() {
        if (MapUtils.isEmpty(this.queryParams)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        try {
            for (Map.Entry<String, String[]> query : this.queryParams.entrySet()) {
                for (String val : query.getValue()) {
                    stringBuilder.append("&").append(URLEncoder.encode(query.getKey(), StandardCharsets.UTF_8.name()));
                    if (val == null || val.isEmpty()) continue;
                    stringBuilder.append("=").append(URLEncoder.encode(val, StandardCharsets.UTF_8.name()));
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            log.error("get query params failed.", (Throwable)e);
            return "";
        }
        return stringBuilder.substring(1);
    }

    public RequestParam setQueryParams(Map<String, String[]> queryParams) {
        this.queryParams = queryParams;
        return this;
    }

    public RequestParam addQueryParam(String key, String value) {
        if (this.queryParams == null) {
            this.queryParams = new HashMap<String, String[]>();
        }
        if (!this.queryParams.containsKey(key)) {
            this.queryParams.put(key, new String[]{value});
        } else {
            this.queryParams.put(key, (String[])Arrays.asList((Serializable)this.queryParams.get(key), value).toArray());
        }
        return this;
    }

    public RequestParam addHeader(String key, Object value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(key, value.toString());
        return this;
    }

    public RequestParam addBody(String key, String value) {
        if (this.body == null) {
            this.body = new HashMap<String, String>();
        }
        this.body.put(key, value);
        return this;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public RequestParam setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestParam)) {
            return false;
        }
        RequestParam other = (RequestParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimeout() != other.getTimeout()) {
            return false;
        }
        String this$queryParams = this.getQueryParams();
        String other$queryParams = other.getQueryParams();
        if (this$queryParams == null ? other$queryParams != null : !this$queryParams.equals(other$queryParams)) {
            return false;
        }
        HttpMethod this$httpMethod = this.getHttpMethod();
        HttpMethod other$httpMethod = other.getHttpMethod();
        if (this$httpMethod == null ? other$httpMethod != null : !this$httpMethod.equals(other$httpMethod)) {
            return false;
        }
        Map<String, String> this$body = this.getBody();
        Map<String, String> other$body = other.getBody();
        if (this$body == null ? other$body != null : !((Object)this$body).equals(other$body)) {
            return false;
        }
        Map<String, String> this$headers = this.getHeaders();
        Map<String, String> other$headers = other.getHeaders();
        return !(this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RequestParam;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timeout = this.getTimeout();
        result = result * 59 + (int)($timeout >>> 32 ^ $timeout);
        String $queryParams = this.getQueryParams();
        result = result * 59 + ($queryParams == null ? 43 : $queryParams.hashCode());
        HttpMethod $httpMethod = this.getHttpMethod();
        result = result * 59 + ($httpMethod == null ? 43 : $httpMethod.hashCode());
        Map<String, String> $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : ((Object)$body).hashCode());
        Map<String, String> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RequestParam(queryParams=" + this.getQueryParams() + ", httpMethod=" + this.getHttpMethod() + ", body=" + this.getBody() + ", headers=" + this.getHeaders() + ", timeout=" + this.getTimeout() + ")";
    }
}

