/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.interceptor;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.context.scope.TraceScope;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PluginLogManager;
import com.navercorp.pinpoint.bootstrap.logging.PluginLogger;
import com.navercorp.pinpoint.bootstrap.util.ScopeUtils;
import java.util.Objects;

public abstract class SpanRecursiveAroundInterceptor
implements AroundInterceptor {
    protected final PluginLogger logger = PluginLogManager.getLogger(this.getClass());
    protected final boolean isDebug = this.logger.isDebugEnabled();
    protected final MethodDescriptor methodDescriptor;
    protected final TraceContext traceContext;
    protected final String scopeName;

    protected SpanRecursiveAroundInterceptor(TraceContext traceContext, MethodDescriptor methodDescriptor, String scopeName) {
        this.traceContext = Objects.requireNonNull(traceContext, "traceContext");
        this.methodDescriptor = Objects.requireNonNull(methodDescriptor, "methodDescriptor");
        this.scopeName = Objects.requireNonNull(scopeName, "scopeName");
    }

    @Override
    public void before(Object target, Object[] args) {
        block8: {
            if (this.isDebug) {
                this.logger.beforeInterceptor(target, args);
            }
            if (this.isSkipTrace()) {
                return;
            }
            try {
                Trace trace = this.createTrace(target, args);
                if (this.isDebug) {
                    this.logger.debug("Created trace. trace={}", (Object)trace);
                }
                if (trace == null) {
                    return;
                }
                if (!this.initScope(trace)) {
                    this.deleteTrace(trace);
                    return;
                }
                this.entryScope(trace);
                if (!trace.canSampled()) {
                    return;
                }
                SpanEventRecorder recorder = trace.traceBlockBegin();
                this.doInBeforeTrace(recorder, target, args);
            }
            catch (Throwable th) {
                if (!this.logger.isWarnEnabled()) break block8;
                this.logger.warn("BEFORE. Caused:{}", (Object)th.getMessage(), (Object)th);
            }
        }
    }

    private boolean isSkipTrace() {
        Trace trace = this.traceContext.currentRawTraceObject();
        if (trace == null) {
            return false;
        }
        if (this.hasScope(trace)) {
            this.entryScope(trace);
            if (this.isDebug) {
                this.logger.debug("Skip recursive invoked");
            }
        } else if (this.isDebug) {
            this.logger.debug("Skip duplicated entry point");
        }
        return true;
    }

    protected abstract void doInBeforeTrace(SpanEventRecorder var1, Object var2, Object[] var3);

    protected abstract Trace createTrace(Object var1, Object[] var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        Trace trace;
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args, result, throwable);
        }
        if ((trace = this.traceContext.currentRawTraceObject()) == null) {
            return;
        }
        if (!this.hasScope(trace)) {
            return;
        }
        if (!this.leaveScope(trace)) {
            this.deleteTrace(trace);
            return;
        }
        if (!this.isEndScope(trace)) {
            return;
        }
        if (!trace.canSampled()) {
            this.deleteTrace(trace);
            return;
        }
        try {
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            this.doInAfterTrace(recorder, target, args, result, throwable);
        }
        catch (Throwable th) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("AFTER. Caused:{}", (Object)th.getMessage(), (Object)th);
            }
        }
        finally {
            trace.traceBlockEnd();
            this.deleteTrace(trace);
        }
    }

    protected abstract void doInAfterTrace(SpanEventRecorder var1, Object var2, Object[] var3, Object var4, Throwable var5);

    private boolean initScope(Trace trace) {
        TraceScope oldScope = trace.addScope(this.scopeName);
        if (oldScope != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Duplicated trace scope={}.", (Object)oldScope.getName());
            }
            return false;
        }
        return true;
    }

    private void entryScope(Trace trace) {
        ScopeUtils.entryScope(trace, this.scopeName);
        if (this.isDebug) {
            this.logger.debug("Try enter trace scope={}", (Object)this.scopeName);
        }
    }

    private boolean leaveScope(Trace trace) {
        if (ScopeUtils.leaveScope(trace, this.scopeName)) {
            if (this.isDebug) {
                this.logger.debug("Leave trace scope={}", (Object)this.scopeName);
            }
            return true;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Failed to leave scope. trace={}", (Object)trace);
        }
        return false;
    }

    private boolean hasScope(Trace trace) {
        return ScopeUtils.hasScope(trace, this.scopeName);
    }

    private boolean isEndScope(Trace trace) {
        return ScopeUtils.isEndScope(trace, this.scopeName);
    }

    private void deleteTrace(Trace trace) {
        this.traceContext.removeTraceObject();
        trace.close();
        if (this.isDebug) {
            this.logger.debug("Delete trace.");
        }
    }
}

