/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.dialect;

import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;
import org.apache.eventmesh.connector.jdbc.table.catalog.Column;

public final class SqlStatementAssembler {
    private final StringBuilder statement = new StringBuilder();

    public SqlStatementAssembler appendSqlSlice(String slice) {
        this.statement.append(slice);
        return this;
    }

    public SqlStatementAssembler appendSqlSliceLists(String delimiter, Collection<String> columnNames, Function<String, String> function) {
        Iterator<String> iterator = columnNames.iterator();
        while (iterator.hasNext()) {
            this.statement.append(function.apply(iterator.next()));
            if (!iterator.hasNext()) continue;
            this.statement.append(delimiter);
        }
        return this;
    }

    public SqlStatementAssembler appendSqlSliceOfColumns(String delimiter, Collection<Column<?>> columns, Function<Column<?>, String> function) {
        Iterator<Column<?>> iterator = columns.iterator();
        while (iterator.hasNext()) {
            this.statement.append(function.apply(iterator.next()));
            if (!iterator.hasNext()) continue;
            this.statement.append(delimiter);
        }
        return this;
    }

    public String build() {
        return this.statement.toString();
    }
}

