/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.sink.hibernate;

import java.util.Map;
import org.apache.eventmesh.connector.jdbc.sink.hibernate.DruidConnectionProvider;
import org.hibernate.SessionFactory;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.service.ServiceRegistry;

public final class HibernateConfiguration {
    public static HibernateConfigurationBuilder newBuilder() {
        return new HibernateConfigurationBuilder();
    }

    public static class HibernateConfigurationBuilder {
        private Configuration configuration = new Configuration();

        public HibernateConfigurationBuilder() {
            this.configuration.setProperty("hibernate.connection.provider_class", DruidConnectionProvider.class.getName());
        }

        public HibernateConfigurationBuilder withUser(String username) {
            this.configuration.setProperty("username", username);
            return this;
        }

        public HibernateConfigurationBuilder withPassword(String password) {
            this.configuration.setProperty("password", password);
            return this;
        }

        public HibernateConfigurationBuilder withUrl(String url) {
            this.configuration.setProperty("url", url);
            return this;
        }

        public HibernateConfigurationBuilder withDruidMaxActive(String maxActive) {
            this.configuration.setProperty("maxActive", maxActive);
            return this;
        }

        public HibernateConfigurationBuilder withShowSql(boolean showSql) {
            this.configuration.setProperty("hibernate.show_sql", Boolean.toString(showSql));
            return this;
        }

        public SessionFactory build() {
            StandardServiceRegistry serviceRegistry = new StandardServiceRegistryBuilder().applySettings((Map)this.configuration.getProperties()).build();
            return this.configuration.buildSessionFactory((ServiceRegistry)serviceRegistry);
        }
    }
}

