/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.type.mysql;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.connector.jdbc.dialect.DatabaseDialect;
import org.apache.eventmesh.connector.jdbc.table.catalog.Column;
import org.apache.eventmesh.connector.jdbc.table.type.SQLType;
import org.apache.eventmesh.connector.jdbc.type.AbstractType;

public class BooleanType
extends AbstractType<Boolean> {
    public static final BooleanType INSTANCE = new BooleanType();

    public BooleanType() {
        super(Boolean.class, SQLType.BOOLEAN, "BOOLEAN");
    }

    @Override
    public String getDefaultValue(DatabaseDialect<?> databaseDialect, Column<?> column) {
        return column.getDefaultValue() == null ? " NULL " : String.format("b'%s'", column.getDefaultValue());
    }

    @Override
    public String getTypeName(Column<?> column) {
        return "bit(1)";
    }

    @Override
    public List<String> ofRegistrationKeys() {
        return Arrays.asList(this.getName(), "bool", "boolean");
    }

    @Override
    public Object convert2DatabaseTypeValue(Object value) {
        if (value instanceof String) {
            return StringUtils.equalsIgnoreCase((CharSequence)"true", (CharSequence)((String)value)) ? 1 : 0;
        }
        return Long.parseLong(value.toString()) > 0L ? 1 : 0;
    }
}

