/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.type.mysql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.eventmesh.connector.jdbc.dialect.DatabaseDialect;
import org.apache.eventmesh.connector.jdbc.table.catalog.Column;
import org.apache.eventmesh.connector.jdbc.type.eventmesh.BytesEventMeshDataType;

public class BytesType
extends BytesEventMeshDataType {
    public static final BytesType INSTANCE = new BytesType();
    private static final List<String> BINARY_REGISTRATION_KEYS = Arrays.asList("BINARY", "binary", "VARBINARY", "varbinary");
    private static final List<String> BLOB_REGISTRATION_KEYS = Arrays.asList("TINYBLOB", "tinyblob", "BLOB", "blob", "MEDIUMBLOB", "mediumblob", "LONGBLOB", "longblob");

    @Override
    public List<String> ofRegistrationKeys() {
        ArrayList<String> registrationCodes = new ArrayList<String>();
        registrationCodes.addAll(super.ofRegistrationKeys());
        registrationCodes.addAll(BINARY_REGISTRATION_KEYS);
        registrationCodes.addAll(BLOB_REGISTRATION_KEYS);
        return registrationCodes;
    }

    @Override
    public String getDefaultValue(DatabaseDialect<?> databaseDialect, Column<?> column) {
        if (BLOB_REGISTRATION_KEYS.contains(column.getNativeType())) {
            return "";
        }
        return column.getDefaultValue() != null ? "0x" + column.getDefaultValue() : "NULL";
    }

    @Override
    public String getTypeName(Column<?> column) {
        if (BLOB_REGISTRATION_KEYS.contains(column.getNativeType())) {
            return column.getNativeType();
        }
        if (BINARY_REGISTRATION_KEYS.contains(column.getNativeType())) {
            int lengthValue = Optional.ofNullable(column.getColumnLength()).orElse(1L).intValue();
            return String.format("%s(%d)", column.getNativeType(), lengthValue);
        }
        return "binary(1)";
    }
}

