/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.util.collections;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.locks.StampedLock;
import org.apache.pulsar.common.util.collections.LongPairSet;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;

public class ConcurrentLongPairSet
implements LongPairSet {
    private static final long EmptyItem = -1L;
    private static final long DeletedItem = -2L;
    private static final float SetFillFactor = 0.66f;
    private static final int DefaultExpectedItems = 256;
    private static final int DefaultConcurrencyLevel = 16;
    private static final float DefaultMapFillFactor = 0.66f;
    private static final float DefaultMapIdleFactor = 0.15f;
    private static final float DefaultExpandFactor = 2.0f;
    private static final float DefaultShrinkFactor = 2.0f;
    private static final boolean DefaultAutoShrink = false;
    private final Section[] sections;
    private static final long HashMixer = -4132994306676758123L;
    private static final int R = 47;

    public static Builder newBuilder() {
        return new Builder();
    }

    @Deprecated
    public ConcurrentLongPairSet() {
        this(256);
    }

    @Deprecated
    public ConcurrentLongPairSet(int expectedItems) {
        this(expectedItems, 16);
    }

    @Deprecated
    public ConcurrentLongPairSet(int expectedItems, int concurrencyLevel) {
        this(expectedItems, concurrencyLevel, 0.66f, 0.15f, false, 2.0f, 2.0f);
    }

    public ConcurrentLongPairSet(int expectedItems, int concurrencyLevel, float mapFillFactor, float mapIdleFactor, boolean autoShrink, float expandFactor, float shrinkFactor) {
        Preconditions.checkArgument(expectedItems > 0);
        Preconditions.checkArgument(concurrencyLevel > 0);
        Preconditions.checkArgument(expectedItems >= concurrencyLevel);
        Preconditions.checkArgument(mapFillFactor > 0.0f && mapFillFactor < 1.0f);
        Preconditions.checkArgument(mapIdleFactor > 0.0f && mapIdleFactor < 1.0f);
        Preconditions.checkArgument(mapFillFactor > mapIdleFactor);
        Preconditions.checkArgument(expandFactor > 1.0f);
        Preconditions.checkArgument(shrinkFactor > 1.0f);
        int numSections = concurrencyLevel;
        int perSectionExpectedItems = expectedItems / numSections;
        int perSectionCapacity = (int)((float)perSectionExpectedItems / 0.66f);
        this.sections = new Section[numSections];
        for (int i = 0; i < numSections; ++i) {
            this.sections[i] = new Section(perSectionCapacity, mapFillFactor, mapIdleFactor, autoShrink, expandFactor, shrinkFactor);
        }
    }

    @Override
    public long size() {
        long size = 0L;
        for (int i = 0; i < this.sections.length; ++i) {
            size += (long)this.sections[i].size;
        }
        return size;
    }

    @Override
    public long capacity() {
        long capacity = 0L;
        for (int i = 0; i < this.sections.length; ++i) {
            capacity += (long)this.sections[i].capacity;
        }
        return capacity;
    }

    @Override
    public boolean isEmpty() {
        for (int i = 0; i < this.sections.length; ++i) {
            if (this.sections[i].size == 0) continue;
            return false;
        }
        return true;
    }

    long getUsedBucketCount() {
        long usedBucketCount = 0L;
        for (int i = 0; i < this.sections.length; ++i) {
            usedBucketCount += (long)this.sections[i].usedBuckets;
        }
        return usedBucketCount;
    }

    @Override
    public boolean contains(long item1, long item2) {
        ConcurrentLongPairSet.checkBiggerEqualZero(item1);
        long h2 = ConcurrentLongPairSet.hash(item1, item2);
        return this.getSection(h2).contains(item1, item2, (int)h2);
    }

    @Override
    public boolean add(long item1, long item2) {
        ConcurrentLongPairSet.checkBiggerEqualZero(item1);
        long h2 = ConcurrentLongPairSet.hash(item1, item2);
        return this.getSection(h2).add(item1, item2, (int)h2);
    }

    @Override
    public boolean remove(long item1, long item2) {
        ConcurrentLongPairSet.checkBiggerEqualZero(item1);
        long h2 = ConcurrentLongPairSet.hash(item1, item2);
        return this.getSection(h2).remove(item1, item2, (int)h2);
    }

    private Section getSection(long hash) {
        int sectionIdx = (int)(hash >>> 32) & this.sections.length - 1;
        return this.sections[sectionIdx];
    }

    @Override
    public void clear() {
        for (Section s2 : this.sections) {
            s2.clear();
        }
    }

    @Override
    public void forEach(LongPairConsumer processor) {
        for (int i = 0; i < this.sections.length; ++i) {
            this.sections[i].forEach(processor);
        }
    }

    @Override
    public int removeIf(LongPairSet.LongPairPredicate filter) {
        int removedValues = 0;
        for (int i = 0; i < this.sections.length; ++i) {
            removedValues += this.sections[i].removeIf(filter);
        }
        return removedValues;
    }

    @Override
    public Set<LongPair> items() {
        HashSet<LongPair> items = new HashSet<LongPair>();
        this.forEach((item1, item2) -> items.add(new LongPair(item1, item2)));
        return items;
    }

    @Override
    public Set<LongPair> items(int numberOfItems) {
        return this.items(numberOfItems, (item1, item2) -> new LongPair(item1, item2));
    }

    @Override
    public <T> Set<T> items(int numberOfItems, LongPairSet.LongPairFunction<T> longPairConverter) {
        HashSet items = new HashSet();
        for (int i = 0; i < this.sections.length; ++i) {
            this.sections[i].forEach((item1, item2) -> {
                if (items.size() < numberOfItems) {
                    items.add(longPairConverter.apply(item1, item2));
                }
            });
            if (items.size() < numberOfItems) continue;
            return items;
        }
        return items;
    }

    static final long hash(long key1, long key2) {
        long hash = key1 * -4132994306676758123L;
        hash ^= hash >>> 47;
        hash *= -4132994306676758123L;
        hash += 31L + key2 * -4132994306676758123L;
        hash ^= hash >>> 47;
        return hash *= -4132994306676758123L;
    }

    static final int signSafeMod(long n, int max) {
        return (int)(n & (long)(max - 1)) << 1;
    }

    private static int alignToPowerOfTwo(int n) {
        return (int)Math.pow(2.0, 32 - Integer.numberOfLeadingZeros(n - 1));
    }

    private static void checkBiggerEqualZero(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("Keys and values must be >= 0");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        AtomicBoolean first = new AtomicBoolean(true);
        this.forEach((item1, item2) -> {
            if (!first.getAndSet(false)) {
                sb.append(", ");
            }
            sb.append('[');
            sb.append(item1);
            sb.append(':');
            sb.append(item2);
            sb.append(']');
        });
        sb.append('}');
        return sb.toString();
    }

    public static class Builder {
        int expectedItems = 256;
        int concurrencyLevel = 16;
        float mapFillFactor = 0.66f;
        float mapIdleFactor = 0.15f;
        float expandFactor = 2.0f;
        float shrinkFactor = 2.0f;
        boolean autoShrink = false;

        public Builder expectedItems(int expectedItems) {
            this.expectedItems = expectedItems;
            return this;
        }

        public Builder concurrencyLevel(int concurrencyLevel) {
            this.concurrencyLevel = concurrencyLevel;
            return this;
        }

        public Builder mapFillFactor(float mapFillFactor) {
            this.mapFillFactor = mapFillFactor;
            return this;
        }

        public Builder mapIdleFactor(float mapIdleFactor) {
            this.mapIdleFactor = mapIdleFactor;
            return this;
        }

        public Builder expandFactor(float expandFactor) {
            this.expandFactor = expandFactor;
            return this;
        }

        public Builder shrinkFactor(float shrinkFactor) {
            this.shrinkFactor = shrinkFactor;
            return this;
        }

        public Builder autoShrink(boolean autoShrink) {
            this.autoShrink = autoShrink;
            return this;
        }

        public ConcurrentLongPairSet build() {
            return new ConcurrentLongPairSet(this.expectedItems, this.concurrencyLevel, this.mapFillFactor, this.mapIdleFactor, this.autoShrink, this.expandFactor, this.shrinkFactor);
        }
    }

    private static final class Section
    extends StampedLock {
        private volatile long[] table;
        private volatile int capacity;
        private final int initCapacity;
        private static final AtomicIntegerFieldUpdater<Section> SIZE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(Section.class, "size");
        private volatile int size;
        private int usedBuckets;
        private int resizeThresholdUp;
        private int resizeThresholdBelow;
        private final float mapFillFactor;
        private final float mapIdleFactor;
        private final float expandFactor;
        private final float shrinkFactor;
        private final boolean autoShrink;

        Section(int capacity, float mapFillFactor, float mapIdleFactor, boolean autoShrink, float expandFactor, float shrinkFactor) {
            this.initCapacity = this.capacity = ConcurrentLongPairSet.alignToPowerOfTwo(capacity);
            this.table = new long[2 * this.capacity];
            this.size = 0;
            this.usedBuckets = 0;
            this.autoShrink = autoShrink;
            this.mapFillFactor = mapFillFactor;
            this.mapIdleFactor = mapIdleFactor;
            this.expandFactor = expandFactor;
            this.shrinkFactor = shrinkFactor;
            this.resizeThresholdUp = (int)((float)this.capacity * mapFillFactor);
            this.resizeThresholdBelow = (int)((float)this.capacity * mapIdleFactor);
            Arrays.fill(this.table, -1L);
        }

        boolean contains(long item1, long item2, int hash) {
            long stamp = this.tryOptimisticRead();
            boolean acquiredLock = false;
            int bucket = ConcurrentLongPairSet.signSafeMod(hash, this.capacity);
            try {
                while (true) {
                    long storedItem1 = this.table[bucket];
                    long storedItem2 = this.table[bucket + 1];
                    if (!acquiredLock && this.validate(stamp)) {
                        if (item1 == storedItem1 && item2 == storedItem2) {
                            boolean bl = true;
                            return bl;
                        }
                        if (storedItem1 == -1L) {
                            boolean bl = false;
                            return bl;
                        }
                    } else {
                        if (!acquiredLock) {
                            stamp = this.readLock();
                            acquiredLock = true;
                            bucket = ConcurrentLongPairSet.signSafeMod(hash, this.capacity);
                            storedItem1 = this.table[bucket];
                            storedItem2 = this.table[bucket + 1];
                        }
                        if (item1 == storedItem1 && item2 == storedItem2) {
                            boolean bl = true;
                            return bl;
                        }
                        if (storedItem1 == -1L) {
                            boolean bl = false;
                            return bl;
                        }
                    }
                    bucket = bucket + 2 & this.table.length - 1;
                }
            }
            finally {
                if (acquiredLock) {
                    this.unlockRead(stamp);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean add(long item1, long item2, long hash) {
            long stamp = this.writeLock();
            int bucket = ConcurrentLongPairSet.signSafeMod(hash, this.capacity);
            int firstDeletedItem = -1;
            try {
                while (true) {
                    long storedItem1 = this.table[bucket];
                    long storedItem2 = this.table[bucket + 1];
                    if (item1 == storedItem1 && item2 == storedItem2) {
                        boolean bl = false;
                        return bl;
                    }
                    if (storedItem1 == -1L) {
                        if (firstDeletedItem != -1) {
                            bucket = firstDeletedItem;
                        } else {
                            ++this.usedBuckets;
                        }
                        this.table[bucket] = item1;
                        this.table[bucket + 1] = item2;
                        SIZE_UPDATER.incrementAndGet(this);
                        boolean bl = true;
                        return bl;
                    }
                    if (storedItem1 == -2L && firstDeletedItem == -1) {
                        firstDeletedItem = bucket;
                    }
                    bucket = bucket + 2 & this.table.length - 1;
                }
            }
            finally {
                if (this.usedBuckets > this.resizeThresholdUp) {
                    try {
                        int newCapacity = ConcurrentLongPairSet.alignToPowerOfTwo((int)((float)this.capacity * this.expandFactor));
                        this.rehash(newCapacity);
                    }
                    finally {
                        this.unlockWrite(stamp);
                    }
                } else {
                    this.unlockWrite(stamp);
                }
            }
        }

        private boolean remove(long item1, long item2, int hash) {
            long stamp = this.writeLock();
            int bucket = ConcurrentLongPairSet.signSafeMod(hash, this.capacity);
            try {
                while (true) {
                    long storedItem1 = this.table[bucket];
                    long storedItem2 = this.table[bucket + 1];
                    if (item1 == storedItem1 && item2 == storedItem2) {
                        SIZE_UPDATER.decrementAndGet(this);
                        this.cleanBucket(bucket);
                        boolean bl = true;
                        return bl;
                    }
                    if (storedItem1 == -1L) {
                        boolean bl = false;
                        return bl;
                    }
                    bucket = bucket + 2 & this.table.length - 1;
                }
            }
            finally {
                this.tryShrinkThenUnlock(stamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int removeIf(LongPairSet.LongPairPredicate filter) {
            Objects.requireNonNull(filter);
            int removedItems = 0;
            long stamp = this.writeLock();
            try {
                for (int bucket = 0; bucket < this.table.length; bucket += 2) {
                    long storedItem1 = this.table[bucket];
                    long storedItem2 = this.table[bucket + 1];
                    if (storedItem1 == -2L || storedItem1 == -1L || !filter.test(storedItem1, storedItem2)) continue;
                    SIZE_UPDATER.decrementAndGet(this);
                    this.cleanBucket(bucket);
                    ++removedItems;
                }
            }
            finally {
                this.tryShrinkThenUnlock(stamp);
            }
            return removedItems;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void tryShrinkThenUnlock(long stamp) {
            if (this.autoShrink && this.size < this.resizeThresholdBelow) {
                try {
                    int newCapacity = Math.max(ConcurrentLongPairSet.alignToPowerOfTwo((int)((float)this.capacity / this.shrinkFactor)), this.initCapacity);
                    int newResizeThresholdUp = (int)((float)newCapacity * this.mapFillFactor);
                    if (newCapacity >= this.capacity || newResizeThresholdUp <= this.size) return;
                    this.rehash(newCapacity);
                    return;
                }
                finally {
                    this.unlockWrite(stamp);
                }
            } else {
                this.unlockWrite(stamp);
            }
        }

        private void cleanBucket(int bucket) {
            int nextInArray = bucket + 2 & this.table.length - 1;
            if (this.table[nextInArray] == -1L) {
                this.table[bucket] = -1L;
                this.table[bucket + 1] = -1L;
                --this.usedBuckets;
                int lastBucket = bucket - 2 & this.table.length - 1;
                while (this.table[lastBucket] == -2L) {
                    this.table[lastBucket] = -1L;
                    this.table[lastBucket + 1] = -1L;
                    --this.usedBuckets;
                    lastBucket = lastBucket - 2 & this.table.length - 1;
                }
            } else {
                this.table[bucket] = -2L;
                this.table[bucket + 1] = -2L;
            }
        }

        void clear() {
            long stamp = this.writeLock();
            try {
                if (this.autoShrink && this.capacity > this.initCapacity) {
                    this.shrinkToInitCapacity();
                } else {
                    Arrays.fill(this.table, -1L);
                    this.size = 0;
                    this.usedBuckets = 0;
                }
            }
            finally {
                this.unlockWrite(stamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void forEach(LongPairConsumer processor) {
            long[] table = this.table;
            long stamp = 0L;
            for (int bucket = 0; bucket < table.length; bucket += 2) {
                if (stamp == 0L) {
                    stamp = this.tryOptimisticRead();
                }
                long storedItem1 = table[bucket];
                long storedItem2 = table[bucket + 1];
                if (!this.validate(stamp)) {
                    stamp = this.readLock();
                    try {
                        storedItem1 = table[bucket];
                        storedItem2 = table[bucket + 1];
                    }
                    finally {
                        this.unlockRead(stamp);
                    }
                    stamp = 0L;
                }
                if (storedItem1 == -2L || storedItem1 == -1L) continue;
                processor.accept(storedItem1, storedItem2);
            }
        }

        private void rehash(int newCapacity) {
            long[] newTable = new long[2 * newCapacity];
            Arrays.fill(newTable, -1L);
            for (int i = 0; i < this.table.length; i += 2) {
                long storedItem1 = this.table[i];
                long storedItem2 = this.table[i + 1];
                if (storedItem1 == -1L || storedItem1 == -2L) continue;
                Section.insertKeyValueNoLock(newTable, newCapacity, storedItem1, storedItem2);
            }
            this.table = newTable;
            this.usedBuckets = this.size;
            this.capacity = newCapacity;
            this.resizeThresholdUp = (int)((float)this.capacity * this.mapFillFactor);
            this.resizeThresholdBelow = (int)((float)this.capacity * this.mapIdleFactor);
        }

        private void shrinkToInitCapacity() {
            long[] newTable = new long[2 * this.initCapacity];
            Arrays.fill(newTable, -1L);
            this.table = newTable;
            this.size = 0;
            this.usedBuckets = 0;
            this.capacity = this.initCapacity;
            this.resizeThresholdUp = (int)((float)this.capacity * this.mapFillFactor);
            this.resizeThresholdBelow = (int)((float)this.capacity * this.mapIdleFactor);
        }

        private static void insertKeyValueNoLock(long[] table, int capacity, long item1, long item2) {
            int bucket = ConcurrentLongPairSet.signSafeMod(ConcurrentLongPairSet.hash(item1, item2), capacity);
            while (true) {
                long storedKey;
                if ((storedKey = table[bucket]) == -1L) {
                    table[bucket] = item1;
                    table[bucket + 1] = item2;
                    return;
                }
                bucket = bucket + 2 & table.length - 1;
            }
        }
    }

    public static interface LongPairConsumer {
        public void accept(long var1, long var3);
    }

    public static class LongPair
    implements Comparable<LongPair> {
        public final long first;
        public final long second;

        public LongPair(long first, long second) {
            this.first = first;
            this.second = second;
        }

        public boolean equals(Object obj) {
            if (obj instanceof LongPair) {
                LongPair other = (LongPair)obj;
                return this.first == other.first && this.second == other.second;
            }
            return false;
        }

        public int hashCode() {
            return (int)ConcurrentLongPairSet.hash(this.first, this.second);
        }

        @Override
        public int compareTo(LongPair o) {
            if (this.first != o.first) {
                return Long.compare(this.first, o.first);
            }
            return Long.compare(this.second, o.second);
        }
    }

    public static interface ConsumerLong {
        public void accept(LongPair var1);
    }
}

