/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.dbsync.binlog;

import com.taobao.tddl.dbsync.binlog.LogBuffer;
import com.taobao.tddl.dbsync.binlog.event.RowsLogBuffer;
import java.nio.charset.Charset;

public class JsonConversion {
    public static final int JSONB_TYPE_SMALL_OBJECT = 0;
    public static final int JSONB_TYPE_LARGE_OBJECT = 1;
    public static final int JSONB_TYPE_SMALL_ARRAY = 2;
    public static final int JSONB_TYPE_LARGE_ARRAY = 3;
    public static final int JSONB_TYPE_LITERAL = 4;
    public static final int JSONB_TYPE_INT16 = 5;
    public static final int JSONB_TYPE_UINT16 = 6;
    public static final int JSONB_TYPE_INT32 = 7;
    public static final int JSONB_TYPE_UINT32 = 8;
    public static final int JSONB_TYPE_INT64 = 9;
    public static final int JSONB_TYPE_UINT64 = 10;
    public static final int JSONB_TYPE_DOUBLE = 11;
    public static final int JSONB_TYPE_STRING = 12;
    public static final int JSONB_TYPE_OPAQUE = 15;
    public static final char JSONB_NULL_LITERAL = '\u0000';
    public static final char JSONB_TRUE_LITERAL = '\u0001';
    public static final char JSONB_FALSE_LITERAL = '\u0002';
    public static final int SMALL_OFFSET_SIZE = 2;
    public static final int LARGE_OFFSET_SIZE = 4;
    public static final int KEY_ENTRY_SIZE_SMALL = 4;
    public static final int KEY_ENTRY_SIZE_LARGE = 6;
    public static final int VALUE_ENTRY_SIZE_SMALL = 3;
    public static final int VALUE_ENTRY_SIZE_LARGE = 5;

    public static Json_Value parse_value(int type, LogBuffer buffer, long len, String charsetName) {
        return JsonConversion.parse_value(type, buffer, len, Charset.forName(charsetName));
    }

    public static Json_Value parse_value(int type, LogBuffer buffer, long len, Charset charset) {
        buffer = buffer.duplicate(buffer.position(), (int)len);
        switch (type) {
            case 0: {
                return JsonConversion.parse_array_or_object(Json_enum_type.OBJECT, buffer, len, false, charset);
            }
            case 1: {
                return JsonConversion.parse_array_or_object(Json_enum_type.OBJECT, buffer, len, true, charset);
            }
            case 2: {
                return JsonConversion.parse_array_or_object(Json_enum_type.ARRAY, buffer, len, false, charset);
            }
            case 3: {
                return JsonConversion.parse_array_or_object(Json_enum_type.ARRAY, buffer, len, true, charset);
            }
        }
        return JsonConversion.parse_scalar(type, buffer, len, charset);
    }

    private static Json_Value parse_array_or_object(Json_enum_type type, LogBuffer buffer, long len, boolean large, Charset charset) {
        long offset_size;
        long l = offset_size = large ? 4L : 2L;
        if (len < 2L * offset_size) {
            throw new IllegalArgumentException("illegal json data");
        }
        long element_count = JsonConversion.read_offset_or_size(buffer, large);
        long bytes = JsonConversion.read_offset_or_size(buffer, large);
        if (bytes > len) {
            throw new IllegalArgumentException("illegal json data");
        }
        long header_size = 2L * offset_size;
        if (type == Json_enum_type.OBJECT) {
            header_size += element_count * (long)(large ? 6 : 4);
        }
        if ((header_size += element_count * (long)(large ? 5 : 3)) > bytes) {
            throw new IllegalArgumentException("illegal json data");
        }
        return new Json_Value(type, buffer.rewind(), element_count, bytes, large);
    }

    private static long read_offset_or_size(LogBuffer buffer, boolean large) {
        return large ? buffer.getUint32() : (long)buffer.getUint16();
    }

    private static Json_Value parse_scalar(int type, LogBuffer buffer, long len, Charset charset) {
        switch (type) {
            case 4: {
                int data = buffer.getUint8();
                switch (data) {
                    case 0: {
                        return new Json_Value(Json_enum_type.LITERAL_NULL);
                    }
                    case 1: {
                        return new Json_Value(Json_enum_type.LITERAL_TRUE);
                    }
                    case 2: {
                        return new Json_Value(Json_enum_type.LITERAL_FALSE);
                    }
                }
                throw new IllegalArgumentException("illegal json data");
            }
            case 5: {
                return new Json_Value(Json_enum_type.INT, buffer.getInt16());
            }
            case 7: {
                return new Json_Value(Json_enum_type.INT, buffer.getInt32());
            }
            case 9: {
                return new Json_Value(Json_enum_type.INT, buffer.getLong64());
            }
            case 6: {
                return new Json_Value(Json_enum_type.UINT, buffer.getUint16());
            }
            case 8: {
                return new Json_Value(Json_enum_type.UINT, buffer.getUint32());
            }
            case 10: {
                return new Json_Value(Json_enum_type.UINT, buffer.getUlong64());
            }
            case 11: {
                return new Json_Value(Json_enum_type.DOUBLE, buffer.getDouble64());
            }
            case 12: {
                int max_bytes = (int)Math.min(len, 5L);
                long tlen = 0L;
                long str_len = 0L;
                long n = 0L;
                byte[] datas = buffer.getData(max_bytes);
                for (int i = 0; i < max_bytes; ++i) {
                    tlen |= (long)((datas[i] & 0x7F) << 7 * i);
                    if ((datas[i] & 0x80) != 0) continue;
                    if (tlen > 0x100000000L) {
                        throw new IllegalArgumentException("illegal json data");
                    }
                    n = i + 1;
                    str_len = tlen;
                    break;
                }
                if (len < n + str_len) {
                    throw new IllegalArgumentException("illegal json data");
                }
                return new Json_Value(Json_enum_type.STRING, buffer.rewind().forward((int)n).getFixString((int)str_len, charset));
            }
            case 15: {
                int type_byte = buffer.getUint8();
                int position = buffer.position();
                int q_max_bytes = (int)Math.min(len - 1L, 5L);
                long q_tlen = 0L;
                long q_str_len = 0L;
                long q_n = 0L;
                byte[] q_datas = buffer.getData(q_max_bytes);
                for (int i = 0; i < q_max_bytes; ++i) {
                    q_tlen |= (long)((q_datas[i] & 0x7F) << 7 * i);
                    if ((q_datas[i] & 0x80) != 0) continue;
                    if (q_tlen > 0x100000000L) {
                        throw new IllegalArgumentException("illegal json data");
                    }
                    q_n = i + 1;
                    q_str_len = q_tlen;
                    break;
                }
                if (q_str_len == 0L || len < q_n + q_str_len) {
                    throw new IllegalArgumentException("illegal json data");
                }
                return new Json_Value(type_byte, buffer.position(position).forward((int)q_n), q_str_len);
            }
        }
        throw new IllegalArgumentException("illegal json data");
    }

    private static StringBuilder escapse(String data) {
        StringBuilder sb = new StringBuilder(data.length());
        int endIndex = data.length();
        for (int i = 0; i < endIndex; ++i) {
            char c = data.charAt(i);
            if (c == '\"') {
                sb.append("\\\"");
                continue;
            }
            if (c == '\n') {
                sb.append("\\n");
                continue;
            }
            if (c == '\r') {
                sb.append("\\r");
                continue;
            }
            if (c == '\\') {
                sb.append("\\\\");
                continue;
            }
            if (c == '\t') {
                sb.append("\\t");
                continue;
            }
            if (c < '\u0010') {
                sb.append("\\u000");
                sb.append(Integer.toHexString(c));
                continue;
            }
            if (c < ' ') {
                sb.append("\\u00");
                sb.append(Integer.toHexString(c));
                continue;
            }
            if (c >= '\u007f' && c <= '\u00a0') {
                sb.append("\\u00");
                sb.append(Integer.toHexString(c));
                continue;
            }
            sb.append(c);
        }
        return sb;
    }

    public static enum Json_enum_type {
        OBJECT,
        ARRAY,
        STRING,
        INT,
        UINT,
        DOUBLE,
        LITERAL_NULL,
        LITERAL_TRUE,
        LITERAL_FALSE,
        OPAQUE,
        ERROR;

    }

    public static class Json_Value {
        Json_enum_type m_type;
        int m_field_type;
        LogBuffer m_data;
        long m_element_count;
        long m_length;
        String m_string_value;
        Number m_int_value;
        double m_double_value;
        boolean m_large;

        public Json_Value(Json_enum_type t) {
            this.m_type = t;
        }

        public Json_Value(Json_enum_type t, Number val) {
            this.m_type = t;
            if (t == Json_enum_type.DOUBLE) {
                this.m_double_value = val.doubleValue();
            } else {
                this.m_int_value = val;
            }
        }

        public Json_Value(Json_enum_type t, String value) {
            this.m_type = t;
            this.m_string_value = value;
        }

        public Json_Value(int field_type, LogBuffer data, long bytes) {
            this.m_type = Json_enum_type.OPAQUE;
            this.m_field_type = field_type;
            this.m_data = data;
            this.m_length = bytes;
        }

        public Json_Value(Json_enum_type t, LogBuffer data, long element_count, long bytes, boolean large) {
            this.m_type = t;
            this.m_data = data;
            this.m_element_count = element_count;
            this.m_length = bytes;
            this.m_large = large;
        }

        public String key(int i, Charset charset) {
            this.m_data.rewind();
            int offset_size = this.m_large ? 4 : 2;
            int key_entry_size = this.m_large ? 6 : 4;
            int entry_offset = 2 * offset_size + key_entry_size * i;
            this.m_data.forward(entry_offset);
            long key_offset = JsonConversion.read_offset_or_size(this.m_data, this.m_large);
            long key_length = this.m_data.getUint16();
            return this.m_data.rewind().forward((int)key_offset).getFixString((int)key_length, charset);
        }

        public Json_Value element(int i, Charset charset) {
            int entry_offset;
            int type;
            this.m_data.rewind();
            int offset_size = this.m_large ? 4 : 2;
            int key_entry_size = this.m_large ? 6 : 4;
            int value_entry_size = this.m_large ? 5 : 3;
            int first_entry_offset = 2 * offset_size;
            if (this.m_type == Json_enum_type.OBJECT) {
                first_entry_offset = (int)((long)first_entry_offset + this.m_element_count * (long)key_entry_size);
            }
            if ((type = this.m_data.forward(entry_offset = first_entry_offset + value_entry_size * i).getUint8()) == 5 || type == 6 || type == 4 || this.m_large && (type == 7 || type == 8)) {
                return JsonConversion.parse_scalar(type, this.m_data, value_entry_size - 1, charset);
            }
            int value_offset = (int)JsonConversion.read_offset_or_size(this.m_data, this.m_large);
            return JsonConversion.parse_value(type, this.m_data.rewind().forward(value_offset), (long)((int)this.m_length - value_offset), charset);
        }

        public StringBuilder toJsonString(StringBuilder buf, Charset charset) {
            switch (this.m_type) {
                case OBJECT: {
                    buf.append("{");
                    int i = 0;
                    while ((long)i < this.m_element_count) {
                        if (i > 0) {
                            buf.append(", ");
                        }
                        buf.append('\"').append(this.key(i, charset)).append('\"');
                        buf.append(": ");
                        this.element(i, charset).toJsonString(buf, charset);
                        ++i;
                    }
                    buf.append("}");
                    break;
                }
                case ARRAY: {
                    buf.append("[");
                    int i = 0;
                    while ((long)i < this.m_element_count) {
                        if (i > 0) {
                            buf.append(", ");
                        }
                        this.element(i, charset).toJsonString(buf, charset);
                        ++i;
                    }
                    buf.append("]");
                    break;
                }
                case DOUBLE: {
                    buf.append(Double.valueOf(this.m_double_value).toString());
                    break;
                }
                case INT: {
                    buf.append(this.m_int_value.toString());
                    break;
                }
                case UINT: {
                    buf.append(this.m_int_value.toString());
                    break;
                }
                case LITERAL_FALSE: {
                    buf.append("false");
                    break;
                }
                case LITERAL_TRUE: {
                    buf.append("true");
                    break;
                }
                case LITERAL_NULL: {
                    buf.append("null");
                    break;
                }
                case OPAQUE: {
                    String text = null;
                    if (this.m_field_type == 246) {
                        int precision = this.m_data.getInt8();
                        int scale = this.m_data.getInt8();
                        text = this.m_data.getDecimal(precision, scale).toPlainString();
                        buf.append(text);
                        break;
                    }
                    if (this.m_field_type == 11) {
                        long packed_value = this.m_data.getLong64();
                        if (packed_value == 0L) {
                            text = "00:00:00";
                        } else {
                            int d;
                            long ultime = Math.abs(packed_value);
                            long intpart = ultime >> 24;
                            int frac = (int)(ultime % 0x1000000L);
                            StringBuilder builder = new StringBuilder(17);
                            if (packed_value < 0L) {
                                builder.append('-');
                            }
                            if ((d = (int)((intpart >> 12) % 1024L)) > 100) {
                                builder.append(String.valueOf(d));
                            } else {
                                RowsLogBuffer.appendNumber2(builder, d);
                            }
                            builder.append(':');
                            RowsLogBuffer.appendNumber2(builder, (int)((intpart >> 6) % 64L));
                            builder.append(':');
                            RowsLogBuffer.appendNumber2(builder, (int)(intpart % 64L));
                            builder.append('.').append(RowsLogBuffer.usecondsToStr(frac, 6));
                            text = builder.toString();
                        }
                        buf.append('\"').append(text).append('\"');
                        break;
                    }
                    if (this.m_field_type == 10 || this.m_field_type == 12 || this.m_field_type == 7) {
                        long packed_value = this.m_data.getLong64();
                        if (packed_value == 0L) {
                            text = "0000-00-00 00:00:00";
                        } else {
                            long ultime = Math.abs(packed_value);
                            long intpart = ultime >> 24;
                            int frac = (int)(ultime % 0x1000000L);
                            long ymd = intpart >> 17;
                            long ym = ymd >> 5;
                            long hms = intpart % 131072L;
                            StringBuilder builder = new StringBuilder(26);
                            RowsLogBuffer.appendNumber4(builder, (int)(ym / 13L));
                            builder.append('-');
                            RowsLogBuffer.appendNumber2(builder, (int)(ym % 13L));
                            builder.append('-');
                            RowsLogBuffer.appendNumber2(builder, (int)(ymd % 32L));
                            builder.append(' ');
                            RowsLogBuffer.appendNumber2(builder, (int)(hms >> 12));
                            builder.append(':');
                            RowsLogBuffer.appendNumber2(builder, (int)((hms >> 6) % 64L));
                            builder.append(':');
                            RowsLogBuffer.appendNumber2(builder, (int)(hms % 64L));
                            builder.append('.').append(RowsLogBuffer.usecondsToStr(frac, 6));
                            text = builder.toString();
                        }
                        buf.append('\"').append(text).append('\"');
                        break;
                    }
                    text = this.m_data.getFixString((int)this.m_length, charset);
                    buf.append('\"').append((CharSequence)JsonConversion.escapse(text)).append('\"');
                    break;
                }
                case STRING: {
                    buf.append('\"').append((CharSequence)JsonConversion.escapse(this.m_string_value)).append('\"');
                    break;
                }
                case ERROR: {
                    throw new IllegalArgumentException("illegal json data");
                }
            }
            return buf;
        }
    }
}

