/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.trace.pinpoint;

import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.eventmesh.common.config.Config;
import org.apache.eventmesh.trace.api.AbstractTraceService;
import org.apache.eventmesh.trace.api.exception.TraceException;
import org.apache.eventmesh.trace.pinpoint.config.PinpointConfiguration;
import org.apache.eventmesh.trace.pinpoint.exporter.PinpointSpanExporter;

@Config.Configs(value={@Config(field="pinpointConfiguration"), @Config(field="exporterConfiguration")})
public class PinpointTraceService
extends AbstractTraceService {
    private transient PinpointConfiguration pinpointConfiguration;

    public void init() throws TraceException {
        long eventMeshTraceExportInterval = this.exporterConfiguration.getEventMeshTraceExportInterval();
        long eventMeshTraceExportTimeout = this.exporterConfiguration.getEventMeshTraceExportTimeout();
        int eventMeshTraceMaxExportSize = this.exporterConfiguration.getEventMeshTraceMaxExportSize();
        int eventMeshTraceMaxQueueSize = this.exporterConfiguration.getEventMeshTraceMaxQueueSize();
        BatchSpanProcessor spanProcessor = BatchSpanProcessor.builder((SpanExporter)new PinpointSpanExporter(this.pinpointConfiguration.getAgentId(), this.pinpointConfiguration.getAgentName(), this.pinpointConfiguration.getApplicationName(), this.pinpointConfiguration.getGrpcTransportConfig())).setScheduleDelay(eventMeshTraceExportInterval, TimeUnit.SECONDS).setExporterTimeout(eventMeshTraceExportTimeout, TimeUnit.SECONDS).setMaxExportBatchSize(eventMeshTraceMaxExportSize).setMaxQueueSize(eventMeshTraceMaxQueueSize).build();
        this.initVars((SpanProcessor)spanProcessor, null);
    }

    public PinpointConfiguration getClientConfiguration() {
        return this.pinpointConfiguration;
    }

    @Generated
    public PinpointConfiguration getPinpointConfiguration() {
        return this.pinpointConfiguration;
    }

    @Generated
    public void setPinpointConfiguration(PinpointConfiguration pinpointConfiguration) {
        this.pinpointConfiguration = pinpointConfiguration;
    }
}

