/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.grpc;

import io.grpc.Metadata;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Header {
    public static final Metadata.Key<String> AGENT_ID_KEY = Header.newStringKey("agentid");
    public static final Metadata.Key<String> AGENT_NAME_KEY = Header.newStringKey("agentname");
    public static final Metadata.Key<String> APPLICATION_NAME_KEY = Header.newStringKey("applicationname");
    public static final Metadata.Key<String> AGENT_START_TIME_KEY = Header.newStringKey("starttime");
    public static final Metadata.Key<String> SOCKET_ID = Header.newStringKey("socketid");
    public static final Metadata.Key<String> SERVICE_TYPE_KEY = Header.newStringKey("servicetype");
    public static final Metadata.Key<String> SUPPORT_COMMAND_CODE = Header.newStringKey("supportCommandCode");
    public static final String SUPPORT_COMMAND_CODE_DELIMITER = ";";
    public static final long SOCKET_ID_NOT_EXIST = -1L;
    public static final List<Integer> SUPPORT_COMMAND_CODE_LIST_NOT_EXIST = null;
    public static final List<Integer> SUPPORT_COMMAND_CODE_LIST_PARSE_ERROR = Collections.emptyList();
    private final String name;
    private final String agentId;
    private final String agentName;
    private final String applicationName;
    private final long agentStartTime;
    private final long socketId;
    private final int serviceType;
    private final List<Integer> supportCommandCodeList;
    private final Map<String, Object> properties;

    private static Metadata.Key<String> newStringKey(String s) {
        return Metadata.Key.of((String)s, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    }

    public Header(String name, String agentId, String agentName, String applicationName, int serviceType, long agentStartTime, long socketId, List<Integer> supportCommandCodeList) {
        this(name, agentId, agentName, applicationName, serviceType, agentStartTime, socketId, supportCommandCodeList, Collections.emptyMap());
    }

    public Header(String name, String agentId, String agentName, String applicationName, int serviceType, long agentStartTime, long socketId, List<Integer> supportCommandCodeList, Map<String, Object> properties) {
        this.name = Objects.requireNonNull(name, "name");
        this.agentId = Objects.requireNonNull(agentId, "agentId");
        this.applicationName = Objects.requireNonNull(applicationName, "applicationName");
        this.serviceType = serviceType;
        this.agentStartTime = agentStartTime;
        this.socketId = socketId;
        this.agentName = agentName;
        this.supportCommandCodeList = supportCommandCodeList;
        this.properties = Objects.requireNonNull(properties, "properties");
    }

    public String getAgentId() {
        return this.agentId;
    }

    public String getAgentName() {
        return this.agentName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public long getAgentStartTime() {
        return this.agentStartTime;
    }

    public long getSocketId() {
        return this.socketId;
    }

    public int getServiceType() {
        return this.serviceType;
    }

    public List<Integer> getSupportCommandCodeList() {
        return this.supportCommandCodeList;
    }

    public Object get(String key) {
        return this.properties.get(key);
    }

    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public String toString() {
        return "Header{name='" + this.name + '\'' + ", agentId='" + this.agentId + '\'' + ", agentName='" + this.agentName + '\'' + ", applicationName='" + this.applicationName + '\'' + ", agentStartTime=" + this.agentStartTime + ", socketId=" + this.socketId + ", serviceType=" + this.serviceType + ", supportCommandCodeList=" + this.supportCommandCodeList + ", properties=" + this.properties + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Header header = (Header)o;
        if (this.agentStartTime != header.agentStartTime) {
            return false;
        }
        if (this.socketId != header.socketId) {
            return false;
        }
        if (this.serviceType != header.serviceType) {
            return false;
        }
        if (this.name != null ? !this.name.equals(header.name) : header.name != null) {
            return false;
        }
        if (this.agentId != null ? !this.agentId.equals(header.agentId) : header.agentId != null) {
            return false;
        }
        if (this.applicationName != null ? !this.applicationName.equals(header.applicationName) : header.applicationName != null) {
            return false;
        }
        if (this.supportCommandCodeList != null ? !this.supportCommandCodeList.equals(header.supportCommandCodeList) : header.supportCommandCodeList != null) {
            return false;
        }
        return this.properties != null ? this.properties.equals(header.properties) : header.properties == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.agentId != null ? this.agentId.hashCode() : 0);
        result = 31 * result + (this.applicationName != null ? this.applicationName.hashCode() : 0);
        result = 31 * result + (int)(this.agentStartTime ^ this.agentStartTime >>> 32);
        result = 31 * result + (int)(this.socketId ^ this.socketId >>> 32);
        result = 31 * result + this.serviceType;
        result = 31 * result + (this.supportCommandCodeList != null ? this.supportCommandCodeList.hashCode() : 0);
        result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
        return result;
    }
}

