/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.grpc.client.retry;

import com.navercorp.pinpoint.grpc.client.retry.ServiceConfigBuilder;
import io.grpc.Status;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class RetryServiceConfigBuilder
implements ServiceConfigBuilder {
    public static final double DEFAULT_MAX_ATTEMPTS = 3.0;
    public static final long DEFAULT_INITIAL_BACKOFF_MILLIS = 1000L;
    public static final long DEFAULT_MAX_BACKOFF_MILLIS = 4000L;
    public static final double DEFAULT_BACKOFF_MULTIPLIER = 2.0;
    public static final List<String> DEFAULT_RETRYABLE_STATUS_CODES = Collections.singletonList(Status.Code.UNAVAILABLE.name());
    private Double maxAttempts = 3.0;
    private String initialBackoff = this.millisToString(1000L);
    private String maxBackoff = this.millisToString(4000L);
    private Double backoffMultiplier = 2.0;
    private List<String> retryableStatusCodes;

    @Override
    public Map<String, ?> buildMetadataConfig() {
        LinkedHashMap<String, Object> methodConfig = new LinkedHashMap<String, Object>();
        this.addMetadataService(methodConfig);
        this.addRetryPolicy(methodConfig);
        return Collections.singletonMap("methodConfig", Collections.singletonList(methodConfig));
    }

    private void addMetadataService(Map<String, Object> methodConfig) {
        Map<String, String> service = Collections.singletonMap("service", "v1.metadata");
        methodConfig.put("name", Collections.singletonList(service));
    }

    private void addRetryPolicy(Map<String, Object> methodConfig) {
        LinkedHashMap<String, Object> retryPolicy = new LinkedHashMap<String, Object>();
        retryPolicy.put("maxAttempts", this.maxAttempts);
        retryPolicy.put("initialBackoff", this.initialBackoff);
        retryPolicy.put("maxBackoff", this.maxBackoff);
        retryPolicy.put("backoffMultiplier", this.backoffMultiplier);
        if (this.retryableStatusCodes == null || this.retryableStatusCodes.isEmpty()) {
            this.retryableStatusCodes = DEFAULT_RETRYABLE_STATUS_CODES;
        }
        retryPolicy.put("retryableStatusCodes", this.retryableStatusCodes);
        methodConfig.put("retryPolicy", retryPolicy);
    }

    public void setMaxAttempts(double maxAttempts) {
        if (maxAttempts >= 2.0) {
            this.maxAttempts = maxAttempts;
        }
    }

    public void setInitialBackOff(long initialBackoff) {
        this.initialBackoff = this.millisToString(initialBackoff);
    }

    public void setMaxBackoff(long maxBackoff) {
        this.maxBackoff = this.millisToString(maxBackoff);
    }

    public void setBackoffMultiplier(double backoffMultiplier) {
        this.backoffMultiplier = backoffMultiplier;
    }

    public void setRetryableStatusCodes(List<String> retryableStatusCodes) {
        this.retryableStatusCodes = retryableStatusCodes;
    }

    public String millisToString(long value) {
        return (double)value / 1000.0 + "s";
    }
}

