/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.grpc.security;

import com.navercorp.pinpoint.common.util.CollectionUtils;
import com.navercorp.pinpoint.common.util.StringUtils;
import com.navercorp.pinpoint.grpc.security.SecurityConstants;
import io.grpc.netty.GrpcSslContexts;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import java.io.InputStream;
import java.security.KeyStore;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SslContextFactory {
    private final Logger LOGGER = LogManager.getLogger(SslContextFactory.class);
    private final SslProvider sslProvider;

    public SslContextFactory(String providerType) throws SSLException {
        Objects.requireNonNull(providerType, "providerType");
        this.sslProvider = this.getSslProvider(providerType);
    }

    public SslContext forServer(InputStream keyCertChainInputStream, InputStream keyInputStream) throws SSLException {
        Objects.requireNonNull(keyCertChainInputStream, "keyCertChainInputStream");
        Objects.requireNonNull(keyInputStream, "keyInputStream");
        try {
            SslContextBuilder sslContextBuilder = SslContextBuilder.forServer((InputStream)keyCertChainInputStream, (InputStream)keyInputStream);
            SslContext sslContext = this.createSslContext(sslContextBuilder, this.sslProvider);
            this.assertValidCipherSuite(sslContext);
            return sslContext;
        }
        catch (SSLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SSLException(e);
        }
    }

    public SslContext forClient(InputStream trustCertCollectionInputStream) throws SSLException {
        Objects.requireNonNull(trustCertCollectionInputStream, "trustCertCollectionInputStream");
        try {
            SslContextBuilder sslContextBuilder = SslContextBuilder.forClient();
            sslContextBuilder.trustManager(trustCertCollectionInputStream);
            return this.createSslContext(sslContextBuilder, this.sslProvider);
        }
        catch (SSLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SSLException(e);
        }
    }

    public SslContext forClient() throws SSLException {
        try {
            SslContextBuilder sslContextBuilder = SslContextBuilder.forClient();
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            sslContextBuilder.trustManager(trustManagerFactory);
            return this.createSslContext(sslContextBuilder, this.sslProvider);
        }
        catch (SSLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SSLException(e);
        }
    }

    private SslContext createSslContext(SslContextBuilder sslContextBuilder, SslProvider sslProvider) throws SSLException {
        sslContextBuilder.sslProvider(sslProvider);
        sslContextBuilder.protocols(SecurityConstants.DEFAULT_SUPPORT_PROTOCOLS.toArray(new String[0]));
        sslContextBuilder.ciphers(SecurityConstants.DEFAULT_SUPPORT_CIPHER_SUITE, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE);
        SslContextBuilder configure = GrpcSslContexts.configure((SslContextBuilder)sslContextBuilder, (SslProvider)sslProvider);
        return configure.build();
    }

    private void assertValidCipherSuite(SslContext sslContext) throws SSLException {
        Objects.requireNonNull(sslContext, "sslContext must not be null");
        List supportedCipherSuiteList = sslContext.cipherSuites();
        if (CollectionUtils.isEmpty((Collection)supportedCipherSuiteList)) {
            throw new SSLException("cipherSuites must not be empty");
        }
        for (String cipherSuite : supportedCipherSuiteList) {
            if (!SecurityConstants.BAD_CIPHER_SUITE_LIST.contains(cipherSuite)) continue;
            throw new SSLException(cipherSuite + " is not safe. Please check this url.(https://httpwg.org/specs/rfc7540.html#BadCipherSuites)");
        }
        this.LOGGER.info("Support cipher list : {} {}", (Object)sslContext, (Object)supportedCipherSuiteList);
    }

    SslProvider getSslProvider(String providerType) throws SSLException {
        if (StringUtils.isEmpty((String)providerType)) {
            return SslProvider.OPENSSL;
        }
        if (SslProvider.OPENSSL.name().equalsIgnoreCase(providerType)) {
            return SslProvider.OPENSSL;
        }
        if (SslProvider.JDK.name().equalsIgnoreCase(providerType)) {
            return SslProvider.JDK;
        }
        throw new SSLException("can't find SslProvider. value:" + providerType);
    }
}

