/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.grpc.server.lifecycle;

import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.grpc.Header;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

public class PingSession {
    private final Long id;
    private final Header header;
    private final AtomicLong eventIdAllocator;
    private short serviceType = ServiceType.UNDEFINED.getCode();
    private boolean updated = false;
    private long lastPingTimeMillis;

    public PingSession(Long id, Header header) {
        this.id = Objects.requireNonNull(id, "transportMetadata");
        this.header = Objects.requireNonNull(header, "header");
        this.eventIdAllocator = new AtomicLong();
    }

    public Header getHeader() {
        return this.header;
    }

    public Long getId() {
        return this.id;
    }

    public long nextEventIdAllocator() {
        return this.eventIdAllocator.incrementAndGet();
    }

    public short getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(short serviceType) {
        this.serviceType = serviceType;
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public void setUpdated(boolean updated) {
        this.updated = updated;
    }

    public long getLastPingTimeMillis() {
        return this.lastPingTimeMillis;
    }

    public void setLastPingTimeMillis(long lastPingTimeMillis) {
        this.lastPingTimeMillis = lastPingTimeMillis;
    }

    public String toString() {
        return "PingSession{id=" + this.id + ", header=" + this.header + ", eventIdAllocator=" + this.eventIdAllocator + ", serviceType=" + this.serviceType + ", updated=" + this.updated + ", lastPingTimeMillis=" + this.lastPingTimeMillis + '}';
    }
}

