/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.redisson.Redisson;
import org.redisson.RedissonMapCache;
import org.redisson.WriteBehindService;
import org.redisson.api.RFuture;
import org.redisson.api.RMapCacheNative;
import org.redisson.api.RedissonClient;
import org.redisson.eviction.EvictionScheduler;

public class MapCacheNativeWrapper<K, V>
extends RedissonMapCache<K, V> {
    private final RMapCacheNative<K, V> cache;

    public MapCacheNativeWrapper(RMapCacheNative<K, V> cache, Redisson redisson) {
        super((EvictionScheduler)null, redisson.getCommandExecutor(), "", (RedissonClient)null, null, (WriteBehindService)null);
        this.cache = cache;
    }

    @Override
    public V getWithTTLOnly(K key) {
        return this.cache.get(key);
    }

    @Override
    public boolean fastPut(K key, V value) {
        return this.cache.fastPut(key, value);
    }

    @Override
    public RFuture<Boolean> fastPutAsync(K key, V value, long ttl, TimeUnit ttlUnit, long maxIdleTime, TimeUnit maxIdleUnit) {
        return this.cache.fastPutAsync(key, value, Duration.ofMillis(ttlUnit.toMillis(ttl)));
    }

    @Override
    public boolean fastPut(K key, V value, long ttl, TimeUnit ttlUnit, long maxIdleTime, TimeUnit maxIdleUnit) {
        return this.cache.fastPut(key, value, Duration.ofMillis(ttlUnit.toMillis(ttl)));
    }

    @Override
    public RFuture<V> putIfAbsentAsync(K key, V value, long ttl, TimeUnit ttlUnit, long maxIdleTime, TimeUnit maxIdleUnit) {
        return this.cache.putIfAbsentAsync(key, value, Duration.ofMillis(ttlUnit.toMillis(ttl)));
    }

    @Override
    public V putIfAbsent(K key, V value, long ttl, TimeUnit ttlUnit, long maxIdleTime, TimeUnit maxIdleUnit) {
        return this.cache.putIfAbsent(key, value, Duration.ofMillis(ttlUnit.toMillis(ttl)));
    }

    @Override
    public boolean containsKey(Object key) {
        return this.cache.containsKey(key);
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public RFuture<Boolean> clearAsync() {
        return this.cache.clearAsync();
    }

    @Override
    public long fastRemove(K ... keys) {
        return this.cache.fastRemove(keys);
    }

    @Override
    public void destroy() {
        this.cache.destroy();
    }
}

