/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.loadbalance;

import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.eventmesh.common.exception.EventMeshException;
import org.apache.eventmesh.common.loadbalance.LoadBalanceSelector;
import org.apache.eventmesh.common.loadbalance.LoadBalanceType;
import org.apache.eventmesh.common.loadbalance.Weight;

public class WeightRandomLoadBalanceSelector<T>
implements LoadBalanceSelector<T> {
    private final transient List<Weight<T>> clusterGroup;
    private final transient int totalWeight;
    private transient boolean sameWeightGroup = true;

    public WeightRandomLoadBalanceSelector(List<Weight<T>> clusterGroup) throws EventMeshException {
        if (CollectionUtils.isEmpty(clusterGroup)) {
            throw new EventMeshException("clusterGroup can not be empty");
        }
        int totalWeight = 0;
        int firstWeight = clusterGroup.get(0).getValue();
        for (Weight<T> weight : clusterGroup) {
            totalWeight += weight.getValue();
            if (!this.sameWeightGroup || firstWeight == weight.getValue()) continue;
            this.sameWeightGroup = false;
        }
        this.clusterGroup = clusterGroup;
        this.totalWeight = totalWeight;
    }

    @Override
    public T select() {
        if (!this.sameWeightGroup) {
            int targetWeight = ThreadLocalRandom.current().nextInt(this.totalWeight);
            for (Weight<T> weight : this.clusterGroup) {
                if ((targetWeight -= weight.getValue()) >= 0) continue;
                return weight.getTarget();
            }
        }
        int length = this.clusterGroup.size();
        return this.clusterGroup.get(ThreadLocalRandom.current().nextInt(length)).getTarget();
    }

    @Override
    public LoadBalanceType getType() {
        return LoadBalanceType.WEIGHT_RANDOM;
    }
}

