/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.openconnect.offsetmgmt.nacos;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.apache.eventmesh.common.config.connector.offset.OffsetStorageConfig;
import org.apache.eventmesh.common.remote.offset.RecordOffset;
import org.apache.eventmesh.common.remote.offset.RecordPartition;
import org.apache.eventmesh.openconnect.offsetmgmt.api.storage.KeyValueStore;
import org.apache.eventmesh.openconnect.offsetmgmt.api.storage.MemoryBasedKeyValueStore;
import org.apache.eventmesh.openconnect.offsetmgmt.api.storage.OffsetManagementService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosConfigService
implements OffsetManagementService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NacosConfigService.class);
    private String serverAddr;
    private String dataId;
    private String group;
    private ConfigService configService;
    private Listener listener;
    public KeyValueStore<RecordPartition, RecordOffset> positionStore;

    public void start() {
        try {
            this.configService.addListener(this.dataId, this.group, this.listener);
        }
        catch (NacosException e) {
            log.error("nacos start error", (Throwable)e);
        }
    }

    public void mergeOffset(RecordPartition recordPartition, RecordOffset recordOffset) {
        if (recordPartition == null) {
            return;
        }
        if (this.positionStore.getKVMap().containsKey(recordPartition)) {
            RecordOffset existedOffset = (RecordOffset)this.positionStore.getKVMap().get(recordPartition);
            if (!recordOffset.equals(existedOffset)) {
                this.positionStore.put((Object)recordPartition, (Object)recordOffset);
            }
        } else {
            this.positionStore.put((Object)recordPartition, (Object)recordOffset);
        }
    }

    public void stop() {
        this.configService.removeListener(this.dataId, this.group, this.listener);
    }

    public void configure(OffsetStorageConfig config) {
    }

    public void persist() {
    }

    public void load() {
    }

    public void synchronize() {
        try {
            Map recordMap = this.positionStore.getKVMap();
            ArrayList recordToSyncList = new ArrayList();
            for (Map.Entry entry : recordMap.entrySet()) {
                HashMap<String, Object> synchronizeMap = new HashMap<String, Object>();
                synchronizeMap.put("recordPartition", entry.getKey());
                synchronizeMap.put("recordOffset", entry.getValue());
                recordToSyncList.add(synchronizeMap);
            }
            log.info("start publish config: dataId={}|group={}|value={}", new Object[]{this.dataId, this.group, recordToSyncList});
            this.configService.publishConfig(this.dataId, this.group, JacksonUtils.toJson(recordToSyncList));
        }
        catch (NacosException e) {
            throw new RuntimeException("Nacos Service publish config error", e);
        }
    }

    public Map<RecordPartition, RecordOffset> getPositionMap() {
        if (this.positionStore.getKVMap() == null || this.positionStore.getKVMap().isEmpty()) {
            try {
                Map configMap = (Map)JacksonUtils.toObj((String)this.configService.getConfig(this.dataId, this.group, 5000L), (TypeReference)new TypeReference<Map<RecordPartition, RecordOffset>>(){});
                this.positionStore.putAll(configMap);
                log.info("nacos position map {}", (Object)configMap);
                return configMap;
            }
            catch (NacosException e) {
                throw new RuntimeException(e);
            }
        }
        log.info("memory position map {}", (Object)this.positionStore.getKVMap());
        return this.positionStore.getKVMap();
    }

    public RecordOffset getPosition(RecordPartition partition) {
        if (this.positionStore.get((Object)partition) == null) {
            try {
                Map recordMap = (Map)JacksonUtils.toObj((String)this.configService.getConfig(this.dataId, this.group, 5000L), (TypeReference)new TypeReference<Map<RecordPartition, RecordOffset>>(){});
                log.info("nacos record position {}", recordMap.get(partition));
                return (RecordOffset)recordMap.get(partition);
            }
            catch (NacosException e) {
                throw new RuntimeException(e);
            }
        }
        log.info("memory record position {}", this.positionStore.get((Object)partition));
        return (RecordOffset)this.positionStore.get((Object)partition);
    }

    public void putPosition(Map<RecordPartition, RecordOffset> positions) {
        this.positionStore.putAll(positions);
    }

    public void putPosition(RecordPartition partition, RecordOffset position) {
        this.positionStore.put((Object)partition, (Object)position);
    }

    public void removePosition(List<RecordPartition> partitions) {
        if (partitions == null) {
            return;
        }
        for (RecordPartition partition : partitions) {
            this.positionStore.remove((Object)partition);
        }
    }

    public void initialize(OffsetStorageConfig config) {
        this.serverAddr = config.getOffsetStorageAddr();
        this.dataId = (String)config.getExtensions().get("dataId");
        this.group = (String)config.getExtensions().get("group");
        this.positionStore = new MemoryBasedKeyValueStore();
        try {
            this.configService = NacosFactory.createConfigService((String)this.serverAddr);
        }
        catch (NacosException e) {
            log.error("nacos init error", (Throwable)e);
        }
        this.listener = new Listener(){

            public Executor getExecutor() {
                return null;
            }

            public void receiveConfigInfo(String configInfo) {
                log.info("nacos config service receive configInfo: {}", (Object)configInfo);
                List recordOffsetList = (List)JacksonUtils.toObj((String)configInfo, (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
                for (Map recordPartitionOffsetMap : recordOffsetList) {
                    RecordPartition recordPartition = (RecordPartition)JacksonUtils.toObj((String)JacksonUtils.toJson(recordPartitionOffsetMap.get("recordPartition")), RecordPartition.class);
                    RecordOffset recordOffset = (RecordOffset)JacksonUtils.toObj((String)JacksonUtils.toJson(recordPartitionOffsetMap.get("recordOffset")), RecordOffset.class);
                    NacosConfigService.this.mergeOffset(recordPartition, recordOffset);
                }
            }
        };
    }

    @Generated
    public String getServerAddr() {
        return this.serverAddr;
    }

    @Generated
    public String getDataId() {
        return this.dataId;
    }

    @Generated
    public String getGroup() {
        return this.group;
    }
}

