/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.grpc.mapper;

import com.navercorp.pinpoint.grpc.trace.PActiveTrace;
import com.navercorp.pinpoint.grpc.trace.PActiveTraceHistogram;
import com.navercorp.pinpoint.grpc.trace.PAgentStat;
import com.navercorp.pinpoint.grpc.trace.PAgentStatBatch;
import com.navercorp.pinpoint.grpc.trace.PCpuLoad;
import com.navercorp.pinpoint.grpc.trace.PDataSource;
import com.navercorp.pinpoint.grpc.trace.PDataSourceList;
import com.navercorp.pinpoint.grpc.trace.PDeadlock;
import com.navercorp.pinpoint.grpc.trace.PDirectBuffer;
import com.navercorp.pinpoint.grpc.trace.PFileDescriptor;
import com.navercorp.pinpoint.grpc.trace.PJvmGc;
import com.navercorp.pinpoint.grpc.trace.PJvmGcDetailed;
import com.navercorp.pinpoint.grpc.trace.PLoadedClass;
import com.navercorp.pinpoint.grpc.trace.PResponseTime;
import com.navercorp.pinpoint.grpc.trace.PTotalThread;
import com.navercorp.pinpoint.grpc.trace.PTransaction;
import com.navercorp.pinpoint.profiler.context.active.ActiveTraceHistogram;
import com.navercorp.pinpoint.profiler.context.active.ActiveTraceHistogramUtils;
import com.navercorp.pinpoint.profiler.context.grpc.mapper.CustomMetricMapper;
import com.navercorp.pinpoint.profiler.context.grpc.mapper.JvmGcTypeMapper;
import com.navercorp.pinpoint.profiler.context.grpc.mapper.MapperUtils;
import com.navercorp.pinpoint.profiler.context.grpc.mapper.ThreadDumpMapper;
import com.navercorp.pinpoint.profiler.context.grpc.mapper.UriStatMapper;
import com.navercorp.pinpoint.profiler.monitor.metric.AgentStatMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.AgentStatMetricSnapshotBatch;
import com.navercorp.pinpoint.profiler.monitor.metric.JvmGcDetailedMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.JvmGcMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.buffer.BufferMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.cpu.CpuLoadMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.datasource.DataSource;
import com.navercorp.pinpoint.profiler.monitor.metric.datasource.DataSourceMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.deadlock.DeadlockMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.filedescriptor.FileDescriptorMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.loadedclass.LoadedClassMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.response.ResponseTimeValue;
import com.navercorp.pinpoint.profiler.monitor.metric.totalthread.TotalThreadMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.transaction.TransactionMetricSnapshot;
import java.util.List;
import org.mapstruct.CollectionMappingStrategy;
import org.mapstruct.InjectionStrategy;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.Named;
import org.mapstruct.NullValueCheckStrategy;
import org.mapstruct.NullValuePropertyMappingStrategy;

@Mapper(componentModel="jsr330", injectionStrategy=InjectionStrategy.CONSTRUCTOR, collectionMappingStrategy=CollectionMappingStrategy.ADDER_PREFERRED, nullValueCheckStrategy=NullValueCheckStrategy.ALWAYS, nullValuePropertyMappingStrategy=NullValuePropertyMappingStrategy.IGNORE, uses={JvmGcTypeMapper.class, ThreadDumpMapper.class, UriStatMapper.class, CustomMetricMapper.class, MapperUtils.class})
public interface AgentStatMapper {
    public static final PAgentStatBatch.Builder pAgentStatBatchBuilder = PAgentStatBatch.newBuilder();

    default public PAgentStatBatch.Builder newBuilder() {
        pAgentStatBatchBuilder.clear();
        return pAgentStatBatchBuilder;
    }

    @Mappings(value={@Mapping(source="agentStats", target="agentStat")})
    public PAgentStatBatch map(AgentStatMetricSnapshotBatch var1);

    @Mappings(value={@Mapping(source="loadedClassCount", target="loadedClass")})
    public PAgentStat map(AgentStatMetricSnapshot var1);

    @Mappings(value={@Mapping(source="type", target="type", qualifiedBy={JvmGcTypeMapper.ToPJvmGcType.class})})
    public PJvmGc map(JvmGcMetricSnapshot var1);

    public PJvmGcDetailed map(JvmGcDetailedMetricSnapshot var1);

    @Mappings(value={@Mapping(source="jvmCpuUsage", target="jvmCpuLoad"), @Mapping(source="systemCpuUsage", target="systemCpuLoad")})
    public PCpuLoad map(CpuLoadMetricSnapshot var1);

    public PTransaction map(TransactionMetricSnapshot var1);

    public PActiveTrace map(ActiveTraceHistogram var1);

    default public PActiveTraceHistogram toPHistogram(ActiveTraceHistogram histogram) {
        if (histogram == null) {
            return null;
        }
        PActiveTraceHistogram.Builder pActiveTraceHistogram = PActiveTraceHistogram.newBuilder();
        if (histogram.getHistogramSchema() != null) {
            int typeCode = histogram.getHistogramSchema().getTypeCode();
            pActiveTraceHistogram.setHistogramSchemaType(typeCode);
        }
        List<Integer> activeTraceCounts = this.toList(histogram);
        pActiveTraceHistogram.addAllActiveTraceCount(activeTraceCounts);
        return pActiveTraceHistogram.build();
    }

    @Named(value="ToActiveTraceCount")
    default public List<Integer> toList(ActiveTraceHistogram histogram) {
        return ActiveTraceHistogramUtils.asList(histogram);
    }

    @Mappings(value={@Mapping(source="dataSourceList", target="dataSource")})
    public PDataSourceList map(DataSourceMetricSnapshot var1);

    @Mappings(value={@Mapping(source="activeConnectionSize", target="activeConnectionSize", conditionQualifiedByName={"isNotZero"})})
    public PDataSource map(DataSource var1);

    @Mappings(value={@Mapping(source="avg", target="avg", conditionQualifiedBy={MapperUtils.IsNotZeroLong.class}), @Mapping(source="max", target="max", conditionQualifiedBy={MapperUtils.IsNotZeroLong.class})})
    public PResponseTime map(ResponseTimeValue var1);

    @Mappings(value={@Mapping(source="deadlockedThreadCount", target="count"), @Mapping(target="threadDump", ignore=true)})
    public PDeadlock map(DeadlockMetricSnapshot var1);

    public PFileDescriptor map(FileDescriptorMetricSnapshot var1);

    public PDirectBuffer map(BufferMetricSnapshot var1);

    public PTotalThread map(TotalThreadMetricSnapshot var1);

    public PLoadedClass map(LoadedClassMetricSnapshot var1);
}

