/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.id;

import com.navercorp.pinpoint.bootstrap.context.SpanId;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.common.profiler.util.TransactionIdUtils;
import java.util.Objects;

public class DefaultTraceId
implements TraceId {
    private final String agentId;
    private final long agentStartTime;
    private final long transactionSequence;
    private final long parentSpanId;
    private final long spanId;
    private final short flags;

    public DefaultTraceId(String agentId, long agentStartTime, long transactionId) {
        this(agentId, agentStartTime, transactionId, -1L, SpanId.newSpanId(), 0);
    }

    public TraceId getNextTraceId() {
        return new DefaultTraceId(this.agentId, this.agentStartTime, this.transactionSequence, this.spanId, SpanId.nextSpanID((long)this.spanId, (long)this.parentSpanId), this.flags);
    }

    public DefaultTraceId(String agentId, long agentStartTime, long transactionId, long parentSpanId, long spanId, short flags) {
        this.agentId = Objects.requireNonNull(agentId, "agentId");
        this.agentStartTime = agentStartTime;
        this.transactionSequence = transactionId;
        this.parentSpanId = parentSpanId;
        this.spanId = spanId;
        this.flags = flags;
    }

    public String getTransactionId() {
        return TransactionIdUtils.formatString((String)this.agentId, (long)this.agentStartTime, (long)this.transactionSequence);
    }

    public String getAgentId() {
        return this.agentId;
    }

    public long getAgentStartTime() {
        return this.agentStartTime;
    }

    public long getTransactionSequence() {
        return this.transactionSequence;
    }

    public long getParentSpanId() {
        return this.parentSpanId;
    }

    public long getSpanId() {
        return this.spanId;
    }

    public short getFlags() {
        return this.flags;
    }

    public boolean isRoot() {
        return this.parentSpanId == -1L;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultTraceId{");
        sb.append("agentId='").append(this.agentId).append('\'');
        sb.append(", agentStartTime=").append(this.agentStartTime);
        sb.append(", transactionSequence=").append(this.transactionSequence);
        sb.append(", parentSpanId=").append(this.parentSpanId);
        sb.append(", spanId=").append(this.spanId);
        sb.append(", flags=").append(this.flags);
        sb.append('}');
        return sb.toString();
    }
}

