/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.profiler.context.CallStackFactory;
import com.navercorp.pinpoint.profiler.context.CallStackFactoryV1;
import com.navercorp.pinpoint.profiler.context.CallStackFactoryV2;
import com.navercorp.pinpoint.profiler.context.SpanEvent;
import com.navercorp.pinpoint.profiler.context.TraceDataFormatVersion;
import com.navercorp.pinpoint.profiler.instrument.config.InstrumentConfig;
import java.util.Objects;

public class CallStackFactoryProvider
implements Provider<CallStackFactory<SpanEvent>> {
    private final TraceDataFormatVersion version;
    private final int callStackMaxDepth;
    private final int callStackMaxSequence;
    private final int callStackOverflowLogRation;

    @Inject
    public CallStackFactoryProvider(InstrumentConfig instrumentConfig, TraceDataFormatVersion version) {
        this.version = Objects.requireNonNull(version, "version");
        this.callStackMaxDepth = instrumentConfig.getCallStackMaxDepth();
        this.callStackMaxSequence = instrumentConfig.getCallStackMaxSequence();
        this.callStackOverflowLogRation = instrumentConfig.getCallStackOverflowLogRation();
    }

    public CallStackFactory<SpanEvent> get() {
        if (this.version == TraceDataFormatVersion.V2) {
            return new CallStackFactoryV2(this.callStackMaxDepth, this.callStackMaxSequence, this.callStackOverflowLogRation);
        }
        if (this.version == TraceDataFormatVersion.V1) {
            return new CallStackFactoryV1(this.callStackMaxDepth, this.callStackMaxSequence, this.callStackOverflowLogRation);
        }
        throw new UnsupportedOperationException("unknown version :" + (Object)((Object)this.version));
    }
}

