/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.profiler.instrument.BytecodeDumpTransformer;
import com.navercorp.pinpoint.profiler.transformer.ClassFileTransformerDispatcher;
import java.lang.instrument.ClassFileTransformer;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClassFileTransformerWrapProvider
implements Provider<ClassFileTransformer> {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final ProfilerConfig profilerConfig;
    private final Provider<ClassFileTransformerDispatcher> classFileTransformerDispatcherProvider;

    @Inject
    public ClassFileTransformerWrapProvider(ProfilerConfig profilerConfig, Provider<ClassFileTransformerDispatcher> classFileTransformerDispatcherProvider) {
        this.profilerConfig = Objects.requireNonNull(profilerConfig, "profilerConfig");
        this.classFileTransformerDispatcherProvider = Objects.requireNonNull(classFileTransformerDispatcherProvider, "classFileTransformerDispatcherProvider");
    }

    public ClassFileTransformer get() {
        ClassFileTransformerDispatcher classFileTransformerDispatcher = (ClassFileTransformerDispatcher)this.classFileTransformerDispatcherProvider.get();
        boolean enableBytecodeDump = this.profilerConfig.readBoolean("bytecode.dump.enable", false);
        if (enableBytecodeDump) {
            this.logger.info("wrapBytecodeDumpTransformer");
            return BytecodeDumpTransformer.wrap(classFileTransformerDispatcher, this.profilerConfig);
        }
        return classFileTransformerDispatcher;
    }
}

