/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider.sampler;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.sampler.Sampler;
import com.navercorp.pinpoint.bootstrap.sampler.TraceSampler;
import com.navercorp.pinpoint.profiler.context.config.ContextConfig;
import com.navercorp.pinpoint.profiler.context.id.IdGenerator;
import com.navercorp.pinpoint.profiler.context.provider.sampler.SamplerConfig;
import com.navercorp.pinpoint.profiler.context.provider.sampler.UrlSamplerConfig;
import com.navercorp.pinpoint.profiler.context.provider.sampler.UrlSamplerInfo;
import com.navercorp.pinpoint.profiler.sampler.BasicTraceSampler;
import com.navercorp.pinpoint.profiler.sampler.RateLimitTraceSampler;
import com.navercorp.pinpoint.profiler.sampler.SamplerType;
import com.navercorp.pinpoint.profiler.sampler.UrlTraceSampler;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TraceSamplerProvider
implements Provider<TraceSampler> {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final Sampler sampler;
    private final IdGenerator idGenerator;
    private final ContextConfig contextConfig;
    private final ProfilerConfig profilerConfig;

    @Inject
    public TraceSamplerProvider(ProfilerConfig profilerConfig, ContextConfig contextConfig, Sampler sampler, IdGenerator idGenerator) {
        this.profilerConfig = Objects.requireNonNull(profilerConfig, "profilerConfig");
        this.contextConfig = Objects.requireNonNull(contextConfig, "contextConfig");
        this.sampler = Objects.requireNonNull(sampler, "sampler");
        this.idGenerator = Objects.requireNonNull(idGenerator, "idGenerator");
    }

    public TraceSampler get() {
        TraceSampler traceSampler = this.newTraceSampler(this.idGenerator, this.sampler, this.contextConfig.getSamplingNewThroughput(), this.contextConfig.getSamplingContinueThroughput());
        SamplerConfig samplerConfig = new SamplerConfig(this.profilerConfig);
        if (Boolean.FALSE.booleanValue() == samplerConfig.isSamplingEnable() || Boolean.FALSE.booleanValue() == samplerConfig.isUrlSamplingEnable()) {
            this.logger.info("TraceSamplerProvider {}", (Object)traceSampler);
            return traceSampler;
        }
        SamplerType samplerType = samplerConfig.getSamplerType();
        TraceSampler urlTraceSampler = this.newUrlSampler(traceSampler, samplerType);
        this.logger.info("TraceSamplerProvider {}", (Object)urlTraceSampler);
        return urlTraceSampler;
    }

    TraceSampler newTraceSampler(IdGenerator idGenerator, Sampler sampler, int samplingNewThroughput, int samplingContinueThroughput) {
        Object traceSampler = new BasicTraceSampler(idGenerator, sampler);
        if (samplingNewThroughput > 0 || samplingContinueThroughput > 0) {
            traceSampler = new RateLimitTraceSampler(samplingNewThroughput, samplingContinueThroughput, idGenerator, (TraceSampler)traceSampler);
        }
        return traceSampler;
    }

    TraceSampler newUrlSampler(TraceSampler defaultTraceSampler, SamplerType samplerType) {
        LinkedHashMap<String, TraceSampler> urlMap = new LinkedHashMap<String, TraceSampler>();
        UrlSamplerConfig urlSamplerConfig = new UrlSamplerConfig(this.profilerConfig, samplerType);
        for (Map.Entry<Integer, UrlSamplerInfo> entry : urlSamplerConfig.entryList()) {
            UrlSamplerInfo urlInfo = entry.getValue();
            if (urlInfo == null || Boolean.FALSE.booleanValue() == urlInfo.isValid()) continue;
            TraceSampler traceSampler = this.newTraceSampler(this.idGenerator, urlInfo.getSampler(), urlInfo.getSamplingNewThroughput(), urlInfo.getSamplingContinueThroughput());
            urlMap.put(urlInfo.getUrlPath(), traceSampler);
        }
        return new UrlTraceSampler(urlMap, defaultTraceSampler);
    }
}

