/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.recorder;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanRecorder;
import com.navercorp.pinpoint.common.trace.AnnotationKey;
import com.navercorp.pinpoint.common.trace.LoggingInfo;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.common.util.DataType;
import com.navercorp.pinpoint.profiler.context.errorhandler.IgnoreErrorHandler;
import com.navercorp.pinpoint.profiler.context.id.LocalTraceRoot;
import com.navercorp.pinpoint.profiler.context.id.Shared;
import java.util.Objects;

public class DisableSpanRecorder
implements SpanRecorder {
    public static final String UNSUPPORTED_OPERATION = "DisableSpanRecorder";
    private final LocalTraceRoot traceRoot;
    private final IgnoreErrorHandler ignoreErrorHandler;

    public DisableSpanRecorder(LocalTraceRoot traceRoot, IgnoreErrorHandler ignoreErrorHandler) {
        this.traceRoot = Objects.requireNonNull(traceRoot, "traceRoot");
        this.ignoreErrorHandler = Objects.requireNonNull(ignoreErrorHandler, "ignoreErrorHandler");
    }

    public boolean canSampled() {
        return false;
    }

    public boolean isRoot() {
        return false;
    }

    public void recordStartTime(long startTime) {
    }

    public void recordTime(boolean autoTimeRecoding) {
    }

    public void recordError() {
        this.getShared().maskErrorCode(1);
    }

    public void recordException(Throwable throwable) {
        this.recordException(true, throwable);
    }

    public void recordException(boolean markError, Throwable throwable) {
        if (markError && !this.ignoreErrorHandler.handleError(throwable)) {
            this.recordError();
        }
    }

    public void recordApiId(int apiId) {
    }

    public void recordApi(MethodDescriptor methodDescriptor) {
    }

    public void recordApi(MethodDescriptor methodDescriptor, Object[] args) {
    }

    public void recordApi(MethodDescriptor methodDescriptor, Object args, int index) {
    }

    public void recordApi(MethodDescriptor methodDescriptor, Object[] args, int start, int end) {
    }

    public void recordApiCachedString(MethodDescriptor methodDescriptor, String args, int index) {
    }

    public void recordAttribute(AnnotationKey key, String value) {
    }

    public void recordAttribute(AnnotationKey key, int value) {
    }

    public void recordAttribute(AnnotationKey key, Integer value) {
    }

    public void recordAttribute(AnnotationKey key, long value) {
    }

    public void recordAttribute(AnnotationKey key, Long value) {
    }

    public void recordAttribute(AnnotationKey key, Object value) {
    }

    public void recordServiceType(ServiceType serviceType) {
    }

    public void recordAttribute(AnnotationKey key, boolean value) {
    }

    public void recordAttribute(AnnotationKey key, double value) {
    }

    public void recordAttribute(AnnotationKey key, byte[] value) {
    }

    public void recordAttribute(AnnotationKey key, DataType value) {
    }

    public void recordRpcName(String rpc) {
    }

    public void recordRemoteAddress(String remoteAddress) {
    }

    public void recordEndPoint(String endPoint) {
    }

    public void recordParentApplication(String parentApplicationName, short parentApplicationType) {
    }

    public void recordAcceptorHost(String host) {
    }

    public void recordLogging(LoggingInfo loggingInfo) {
    }

    public void recordStatusCode(int statusCode) {
        this.getShared().setStatusCode(statusCode);
    }

    public boolean recordUriTemplate(String uriTemplate) {
        return this.recordUriTemplate(uriTemplate, false);
    }

    public boolean recordUriTemplate(String uriTemplate, boolean force) {
        return this.getShared().setUriTemplate(uriTemplate, force);
    }

    public boolean recordUriHttpMethod(String httpMethod) {
        return this.getShared().setHttpMethods(httpMethod);
    }

    private Shared getShared() {
        return this.traceRoot.getShared();
    }

    public Object attachFrameObject(Object frameObject) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    public Object getFrameObject() {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    public Object detachFrameObject() {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }
}

