/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument;

import com.google.inject.Provider;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.interceptor.Interceptor;
import com.navercorp.pinpoint.profiler.instrument.EngineComponent;
import com.navercorp.pinpoint.profiler.instrument.ScopeFactory;
import com.navercorp.pinpoint.profiler.instrument.interceptor.InterceptorDefinition;
import com.navercorp.pinpoint.profiler.instrument.interceptor.InterceptorDefinitionFactory;
import com.navercorp.pinpoint.profiler.interceptor.registry.InterceptorRegistryBinder;
import com.navercorp.pinpoint.profiler.metadata.ApiMetaDataService;
import com.navercorp.pinpoint.profiler.objectfactory.ObjectBinderFactory;
import java.util.Objects;

public class DefaultEngineComponent
implements EngineComponent {
    private final ObjectBinderFactory objectBinderFactory;
    private final InterceptorRegistryBinder interceptorRegistryBinder;
    private final InterceptorDefinitionFactory interceptorDefinitionFactory;
    private final Provider<ApiMetaDataService> apiMetaDataServiceProvider;
    private final ScopeFactory scopeFactory;

    public DefaultEngineComponent(ObjectBinderFactory objectBinderFactory, InterceptorRegistryBinder interceptorRegistryBinder, InterceptorDefinitionFactory interceptorDefinitionFactory, Provider<ApiMetaDataService> apiMetaDataServiceProvider, ScopeFactory scopeFactory) {
        this.objectBinderFactory = Objects.requireNonNull(objectBinderFactory, "objectBinderFactory");
        this.interceptorRegistryBinder = Objects.requireNonNull(interceptorRegistryBinder, "interceptorRegistryBinder");
        this.interceptorDefinitionFactory = Objects.requireNonNull(interceptorDefinitionFactory, "interceptorDefinitionFactory");
        this.apiMetaDataServiceProvider = Objects.requireNonNull(apiMetaDataServiceProvider, "apiMetaDataService");
        this.scopeFactory = Objects.requireNonNull(scopeFactory, "scopeFactory");
    }

    @Override
    public ScopeFactory getScopeFactory() {
        return this.scopeFactory;
    }

    @Override
    public InterceptorDefinition createInterceptorDefinition(Class<?> interceptorClazz) {
        return this.interceptorDefinitionFactory.createInterceptorDefinition(interceptorClazz);
    }

    @Override
    public ObjectBinderFactory getObjectBinderFactory() {
        return this.objectBinderFactory;
    }

    @Override
    public int addInterceptor(Interceptor interceptor) {
        return this.interceptorRegistryBinder.getInterceptorRegistryAdaptor().addInterceptor(interceptor);
    }

    @Override
    public int addInterceptor() {
        return this.interceptorRegistryBinder.getInterceptorRegistryAdaptor().addInterceptor();
    }

    @Override
    public int cacheApi(MethodDescriptor methodDescriptor) {
        ApiMetaDataService apiMetaDataService = (ApiMetaDataService)this.apiMetaDataServiceProvider.get();
        return apiMetaDataService.cacheApi(methodDescriptor);
    }
}

