/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument.classreading;

import com.navercorp.pinpoint.common.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.Type;

public class ClassReaderWrapper {
    private final ClassReader classReader;
    private final List<String> annotationInternalNames = new ArrayList<String>();
    private boolean innerClass = false;

    public ClassReaderWrapper(byte[] classBinary) {
        this(classBinary, false);
    }

    public ClassReaderWrapper(byte[] classBinary, boolean readAttributes) {
        Objects.requireNonNull(classBinary, "classBinary");
        this.classReader = new ClassReader(classBinary);
        if (readAttributes) {
            this.readAttributes();
        }
    }

    public ClassReaderWrapper(ClassLoader classLoader, String classInternalName) throws IOException {
        this(classLoader, classInternalName, false);
    }

    public ClassReaderWrapper(ClassLoader classLoader, String classInternalName, boolean readAttributes) throws IOException {
        Objects.requireNonNull(classInternalName, "classInternalName");
        ClassLoader cl = classLoader;
        if (cl == null && (cl = ClassLoader.getSystemClassLoader()) == null) {
            throw new IOException("system classloader is null.");
        }
        String classPath = classInternalName.concat(".class");
        InputStream in = cl.getResourceAsStream(classPath);
        if (in == null) {
            throw new IOException("not found class. classLoader=" + cl + ", classInternalName=" + classInternalName);
        }
        byte[] bytes = IOUtils.toByteArray((InputStream)in);
        this.classReader = new ClassReader(bytes);
        if (readAttributes) {
            this.readAttributes();
        }
    }

    public int getAccess() {
        return this.classReader.getAccess();
    }

    public int getVersion() {
        return this.classReader.readShort(6);
    }

    public String getSuperClassInternalName() {
        return this.classReader.getSuperName();
    }

    public String getClassInternalName() {
        return this.classReader.getClassName();
    }

    public List<String> getInterfaceInternalNames() {
        return Arrays.asList(this.classReader.getInterfaces());
    }

    public byte[] getClassBinary() {
        return this.classReader.b;
    }

    public List<String> getAnnotationInternalNames() {
        return this.annotationInternalNames;
    }

    public boolean isInnerClass() {
        return this.innerClass;
    }

    public boolean isInterface() {
        return (this.classReader.getAccess() & 0x200) != 0;
    }

    public boolean isAnnotation() {
        return (this.classReader.getAccess() & 0x2000) != 0;
    }

    public boolean isSynthetic() {
        return (this.classReader.getAccess() & 0x1000) != 0;
    }

    private void readAttributes() {
        char[] c = new char[this.classReader.getMaxStringLength()];
        int u = this.getAttributes();
        int anns = 0;
        int ianns = 0;
        for (int i = this.classReader.readUnsignedShort(u); i > 0; --i) {
            String attrName = this.classReader.readUTF8(u + 2, c);
            if ("EnclosingMethod".equals(attrName)) {
                if (this.classReader.readClass(u + 8, c) != null) {
                    this.innerClass = true;
                }
            } else if ("RuntimeVisibleAnnotations".equals(attrName)) {
                anns = u + 8;
            } else if ("RuntimeInvisibleAnnotations".equals(attrName)) {
                ianns = u + 8;
            }
            u += 6 + this.classReader.readInt(u + 4);
        }
        if (anns != 0) {
            this.readAnnotationInternalName(anns, c);
        }
        if (ianns != 0) {
            this.readAnnotationInternalName(ianns, c);
        }
    }

    private int getAttributes() {
        int j;
        int i;
        int header = this.classReader.header;
        int u = header + 8 + this.classReader.readUnsignedShort(header + 6) * 2;
        for (i = this.classReader.readUnsignedShort(u); i > 0; --i) {
            for (j = this.classReader.readUnsignedShort(u + 8); j > 0; --j) {
                u += 6 + this.classReader.readInt(u + 12);
            }
            u += 8;
        }
        for (i = this.classReader.readUnsignedShort(u += 2); i > 0; --i) {
            for (j = this.classReader.readUnsignedShort(u + 8); j > 0; --j) {
                u += 6 + this.classReader.readInt(u + 12);
            }
            u += 8;
        }
        return u + 2;
    }

    private void readAnnotationInternalName(int annotationIndex, char[] buf) {
        int v = annotationIndex + 2;
        for (int i = this.classReader.readUnsignedShort(annotationIndex); i > 0; --i) {
            String internalName;
            String annotationDesc = this.classReader.readUTF8(v, buf);
            Type type = Type.getType((String)annotationDesc);
            if (type.getSort() == 10 && (internalName = type.getInternalName()) != null) {
                this.annotationInternalNames.add(internalName);
            }
            v = this.readAnnotationValues(v + 2, buf, true);
        }
    }

    private int readAnnotationValues(int v, char[] buf, boolean named) {
        int i = this.classReader.readUnsignedShort(v);
        v += 2;
        if (named) {
            while (i > 0) {
                v = this.readAnnotationValue(v + 2, buf);
                --i;
            }
        } else {
            while (i > 0) {
                v = this.readAnnotationValue(v, buf);
                --i;
            }
        }
        return v;
    }

    private int readAnnotationValue(int v, char[] buf) {
        switch (this.classReader.b[v] & 0xFF) {
            case 101: {
                return v + 5;
            }
            case 64: {
                return this.readAnnotationValues(v + 3, buf, true);
            }
            case 91: {
                return this.readAnnotationValues(v + 1, buf, false);
            }
        }
        return v + 3;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("{");
        sb.append("access=").append(this.classReader.getAccess()).append(", ");
        sb.append("name=").append(this.classReader.getClassName()).append(", ");
        sb.append("interfaces=").append(Arrays.toString(this.classReader.getInterfaces())).append(", ");
        sb.append("super=").append(this.classReader.getSuperName());
        sb.append("}");
        return sb.toString();
    }
}

