/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.plugin.filter;

import com.navercorp.pinpoint.profiler.plugin.PluginJar;
import com.navercorp.pinpoint.profiler.plugin.filter.PluginFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class PluginFilters
implements PluginFilter {
    private final List<PluginFilter> pluginFilters = new ArrayList<PluginFilter>();

    public PluginFilters(PluginFilter ... pluginFilters) {
        Objects.requireNonNull(pluginFilters, "pluginFilters");
        this.pluginFilters.addAll(Arrays.asList(pluginFilters));
    }

    @Override
    public boolean accept(PluginJar pluginJar) {
        for (PluginFilter pluginFilter : this.pluginFilters) {
            if (pluginFilter.accept(pluginJar)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PluginJarFilters{");
        sb.append("pluginJarFilters=").append(this.pluginFilters);
        sb.append('}');
        return sb.toString();
    }
}

