/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.driver.mysql.packets;

import com.alibaba.otter.canal.parse.driver.mysql.packets.GTIDSet;
import com.alibaba.otter.canal.parse.driver.mysql.packets.MariaGtid;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class MariaGTIDSet
implements GTIDSet {
    private Map<Long, MariaGtid> gtidMap = new HashMap<Long, MariaGtid>();

    @Override
    public byte[] encode() throws IOException {
        return this.toString().getBytes();
    }

    @Override
    public void update(String str) {
        MariaGtid mariaGtid = MariaGtid.parse(str);
        this.gtidMap.put(mariaGtid.getDomainId(), mariaGtid);
    }

    public void add(MariaGtid mariaGtid) {
        this.gtidMap.put(mariaGtid.getDomainId(), mariaGtid);
    }

    public static MariaGTIDSet parse(String gtidData) {
        HashMap<Long, MariaGtid> gtidMap = new HashMap<Long, MariaGtid>();
        if (StringUtils.isNotEmpty((String)gtidData)) {
            String[] gtidStrs;
            for (String gtid : gtidStrs = gtidData.replaceAll("\n", "").split(",")) {
                MariaGtid mariaGtid = MariaGtid.parse(gtid);
                gtidMap.put(mariaGtid.getDomainId(), mariaGtid);
            }
        }
        MariaGTIDSet gtidSet = new MariaGTIDSet();
        gtidSet.gtidMap = gtidMap;
        return gtidSet;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (MariaGtid gtid : this.gtidMap.values()) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(gtid.toString());
        }
        return sb.toString();
    }
}

