/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.loadbalance;

import java.util.concurrent.atomic.AtomicInteger;

public class Weight<T> {
    private T target;
    private final int value;
    private final AtomicInteger currentWeight;

    public Weight(T target, int value) {
        this.target = target;
        this.value = value;
        this.currentWeight = new AtomicInteger(0);
    }

    public void decreaseTotal(int total) {
        this.currentWeight.addAndGet(-1 * total);
    }

    public void increaseCurrentWeight() {
        this.currentWeight.addAndGet(this.value);
    }

    public T getTarget() {
        return this.target;
    }

    public void setTarget(T target) {
        this.target = target;
    }

    public int getValue() {
        return this.value;
    }

    public AtomicInteger getCurrentWeight() {
        return this.currentWeight;
    }

    public String toString() {
        return "Wight{target=" + this.target + ", value=" + this.value + ", currentWeight=" + this.currentWeight + '}';
    }
}

