/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.trace;

import com.navercorp.pinpoint.common.trace.AnnotationKey;
import com.navercorp.pinpoint.common.trace.AnnotationKeyMatcher;
import com.navercorp.pinpoint.common.util.AnnotationKeyUtils;

public final class AnnotationKeyMatchers {
    public static final AnnotationKeyMatcher NOTHING_MATCHER = new AnnotationKeyMatcher(){

        @Override
        public boolean matches(int code) {
            return false;
        }

        public String toString() {
            return "NOTHING_MATCHER";
        }
    };
    public static final AnnotationKeyMatcher ARGS_MATCHER = new AnnotationKeyMatcher(){

        @Override
        public boolean matches(int code) {
            return AnnotationKeyUtils.isArgsKey(code);
        }

        public String toString() {
            return "ARGS_MATCHER";
        }
    };

    private AnnotationKeyMatchers() {
    }

    public static AnnotationKeyMatcher exact(AnnotationKey key) {
        return new ExactMatcher(key.getCode());
    }

    public static AnnotationKeyMatcher exact(int code) {
        return new ExactMatcher(code);
    }

    private static class ExactMatcher
    implements AnnotationKeyMatcher {
        private final int code;

        public ExactMatcher(int code) {
            this.code = code;
        }

        @Override
        public boolean matches(int code) {
            return this.code == code;
        }

        public String toString() {
            return "ExactMatcher(" + this.code + ")";
        }
    }
}

