/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Objects;

public final class FileUtils {
    private FileUtils() {
    }

    public static File[] listFiles(File path, final String[] fileExtensions) {
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(fileExtensions, "fileExtensions");
        return path.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String path = pathname.getName();
                for (String extension : fileExtensions) {
                    if (path.lastIndexOf(extension) == -1) continue;
                    return true;
                }
                return false;
            }
        });
    }

    public static URL toURL(File file) throws IOException {
        Objects.requireNonNull(file, "file");
        return FileUtils.toURL(file, new FileFunction());
    }

    public static URL toURL(String filePath) throws IOException {
        Objects.requireNonNull(filePath, "filePath");
        return FileUtils.toURL(filePath, new FilePathFunction());
    }

    public static URL[] toURLs(File[] files) throws IOException {
        Objects.requireNonNull(files, "files");
        return FileUtils.toURLs(files, new FileFunction());
    }

    public static URL[] toURLs(String[] filePaths) throws IOException {
        Objects.requireNonNull(filePaths, "filePaths");
        return FileUtils.toURLs(filePaths, new FilePathFunction());
    }

    private static <T> URL toURL(T source, Function<T, URI> function) throws IOException {
        URI uri = function.apply(source);
        return uri.toURL();
    }

    private static <T> URL[] toURLs(T[] source, Function<T, URI> function) throws IOException {
        URL[] urls = new URL[source.length];
        for (int i = 0; i < source.length; ++i) {
            T t = source[i];
            urls[i] = FileUtils.toURL(t, function);
        }
        return urls;
    }

    private static class FilePathFunction
    implements Function<String, URI> {
        private FilePathFunction() {
        }

        @Override
        public URI apply(String filePath) {
            File file = new File(filePath);
            return file.toURI();
        }
    }

    private static class FileFunction
    implements Function<File, URI> {
        private FileFunction() {
        }

        @Override
        public URI apply(File file) {
            return file.toURI();
        }
    }

    private static interface Function<T, R> {
        public R apply(T var1);
    }
}

