/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.util;

import java.util.EnumSet;

public enum OsType {
    UNKNOWN(null),
    WINDOW("Window"),
    MAC("Mac"),
    LINUX("Linux"),
    SOLARIS("Solaris"),
    AIX("AIX"),
    HP_UX("HP-UX"),
    BSD("BSD");

    private final String inclusiveString;
    private static final EnumSet<OsType> OS_TYPE;

    public String getInclusiveString() {
        return this.inclusiveString;
    }

    private OsType(String inclusiveString) {
        this.inclusiveString = inclusiveString;
    }

    public static OsType fromVendor(String vendorName) {
        if (vendorName == null) {
            return UNKNOWN;
        }
        String vendorNameTrimmed = vendorName.trim();
        for (OsType osType : OS_TYPE) {
            if (!osType.toString().equalsIgnoreCase(vendorNameTrimmed)) continue;
            return osType;
        }
        return UNKNOWN;
    }

    public static OsType fromOsName(String osName) {
        if (osName == null) {
            return UNKNOWN;
        }
        for (OsType osType : OS_TYPE) {
            if (osType.inclusiveString == null || !osName.toLowerCase().contains(osType.inclusiveString.toLowerCase())) continue;
            return osType;
        }
        return UNKNOWN;
    }

    static {
        OS_TYPE = EnumSet.allOf(OsType.class);
    }
}

